/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.composite;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.opensearch.common.CheckedFunction;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasables;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.BigArrays;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.BitArray;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.DoubleArray;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.search.DocValueFormat;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.LeafBucketCollector;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.composite.SortedDocsProducer;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.missing.MissingOrder;

class DoubleValuesSource
extends SingleDimensionValuesSource<Double> {
    private final CheckedFunction<LeafReaderContext, SortedNumericDoubleValues, IOException> docValuesFunc;
    private final BitArray bits;
    private DoubleArray values;
    private double currentValue;
    private boolean missingCurrentValue;

    DoubleValuesSource(BigArrays bigArrays, MappedFieldType fieldType, CheckedFunction<LeafReaderContext, SortedNumericDoubleValues, IOException> docValuesFunc, DocValueFormat format, boolean missingBucket, MissingOrder missingOrder, int size, int reverseMul) {
        super(bigArrays, format, fieldType, missingBucket, missingOrder, size, reverseMul);
        this.docValuesFunc = docValuesFunc;
        this.bits = missingBucket ? new BitArray(100L, bigArrays) : null;
        this.values = bigArrays.newDoubleArray(Math.min(size, 100), false);
    }

    @Override
    void copyCurrent(int slot) {
        this.values = this.bigArrays.grow(this.values, (long)(slot + 1));
        if (this.missingBucket && this.missingCurrentValue) {
            this.bits.clear(slot);
        } else {
            assert (!this.missingCurrentValue);
            if (this.missingBucket) {
                this.bits.set(slot);
            }
            this.values.set(slot, this.currentValue);
        }
    }

    @Override
    int compare(int from, int to) {
        int result;
        if (this.missingBucket && !MissingOrder.unknownOrder(result = this.missingOrder.compare(() -> !this.bits.get(from), () -> !this.bits.get(to), this.reverseMul))) {
            return result;
        }
        return this.compareValues(this.values.get(from), this.values.get(to));
    }

    @Override
    int compareCurrent(int slot) {
        int result;
        if (this.missingBucket && !MissingOrder.unknownOrder(result = this.missingOrder.compare(() -> this.missingCurrentValue, () -> !this.bits.get(slot), this.reverseMul))) {
            return result;
        }
        return this.compareValues(this.currentValue, this.values.get(slot));
    }

    @Override
    int compareCurrentWithAfter() {
        int result;
        if (this.missingBucket && !MissingOrder.unknownOrder(result = this.missingOrder.compare(() -> this.missingCurrentValue, () -> this.afterValue == null, this.reverseMul))) {
            return result;
        }
        return this.compareValues(this.currentValue, (Double)this.afterValue);
    }

    @Override
    int hashCode(int slot) {
        if (this.missingBucket && !this.bits.get(slot)) {
            return 0;
        }
        return Double.hashCode(this.values.get(slot));
    }

    @Override
    int hashCodeCurrent() {
        if (this.missingCurrentValue) {
            return 0;
        }
        return Double.hashCode(this.currentValue);
    }

    private int compareValues(double v1, double v2) {
        return Double.compare(v1, v2) * this.reverseMul;
    }

    @Override
    void setAfter(Comparable value) {
        this.afterValue = this.missingBucket && value == null ? null : (value instanceof Number ? Double.valueOf(((Number)((Object)value)).doubleValue()) : Double.valueOf(this.format.parseDouble(value.toString(), false, () -> {
            throw new IllegalArgumentException("now() is not supported in [after] key");
        })));
    }

    @Override
    Double toComparable(int slot) {
        if (this.missingBucket && !this.bits.get(slot)) {
            return null;
        }
        assert (!this.missingBucket || this.bits.get(slot));
        return this.values.get(slot);
    }

    @Override
    LeafBucketCollector getLeafCollector(LeafReaderContext context, final LeafBucketCollector next) throws IOException {
        final SortedNumericDoubleValues dvs = this.docValuesFunc.apply(context);
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (dvs.advanceExact(doc)) {
                    int num = dvs.docValueCount();
                    for (int i = 0; i < num; ++i) {
                        DoubleValuesSource.this.currentValue = dvs.nextValue();
                        DoubleValuesSource.this.missingCurrentValue = false;
                        next.collect(doc, bucket);
                    }
                } else if (DoubleValuesSource.this.missingBucket) {
                    DoubleValuesSource.this.missingCurrentValue = true;
                    next.collect(doc, bucket);
                }
            }
        };
    }

    @Override
    LeafBucketCollector getLeafCollector(Comparable value, LeafReaderContext context, final LeafBucketCollector next) {
        if (value.getClass() != Double.class) {
            throw new IllegalArgumentException("Expected Double, got " + value.getClass());
        }
        this.currentValue = (Double)value;
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                next.collect(doc, bucket);
            }
        };
    }

    @Override
    SortedDocsProducer createSortedDocsProducerOrNull(IndexReader reader, Query query) {
        return null;
    }

    @Override
    public void close() {
        Releasables.close(this.values, this.bits);
    }
}

