/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.CollectionUtil;
import org.graylog.shaded.opensearch2.org.opensearch.common.Randomness;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.SetBackedScalingCuckooFilter;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.DocValueFormat;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationExecutionException;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.BucketOrder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalMultiBucketAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.InternalRareTerms;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.UnmappedRareTerms;

public abstract class InternalMappedRareTerms<A extends InternalRareTerms<A, B>, B extends InternalRareTerms.Bucket<B>>
extends InternalRareTerms<A, B> {
    protected DocValueFormat format;
    protected List<B> buckets;
    protected Map<String, B> bucketMap;
    final SetBackedScalingCuckooFilter filter;
    protected final Logger logger = LogManager.getLogger(this.getClass());

    InternalMappedRareTerms(String name, BucketOrder order, Map<String, Object> metadata, DocValueFormat format, List<B> buckets, long maxDocCount, SetBackedScalingCuckooFilter filter) {
        super(name, order, maxDocCount, metadata);
        this.format = format;
        this.buckets = buckets;
        this.filter = filter;
    }

    public long getMaxDocCount() {
        return this.maxDocCount;
    }

    SetBackedScalingCuckooFilter getFilter() {
        return this.filter;
    }

    InternalMappedRareTerms(StreamInput in, InternalRareTerms.Bucket.Reader<B> bucketReader) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.buckets = in.readList(stream -> bucketReader.read(stream, this.format));
        this.filter = new SetBackedScalingCuckooFilter(in, Randomness.get());
    }

    @Override
    protected void writeTermTypeInfoTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeList(this.buckets);
        this.filter.writeTo(out);
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        HashMap<Object, List> buckets = new HashMap<Object, List>();
        Object referenceTerms = null;
        SetBackedScalingCuckooFilter filter = null;
        for (InternalAggregation aggregation : aggregations) {
            if (!aggregation.isMapped()) continue;
            InternalRareTerms terms = (InternalRareTerms)aggregation;
            if (referenceTerms == null && !aggregation.getClass().equals(UnmappedRareTerms.class)) {
                referenceTerms = terms;
            }
            if (referenceTerms != null && !referenceTerms.getClass().equals(terms.getClass()) && !terms.getClass().equals(UnmappedRareTerms.class)) {
                throw new AggregationExecutionException("Merging/Reducing the aggregations failed when computing the aggregation [" + ((InternalAggregation)referenceTerms).getName() + "] because the field you gave in the aggregation query existed as two different types in two different indices");
            }
            for (InternalRareTerms.Bucket bucket : terms.getBuckets()) {
                List bucketList = buckets.computeIfAbsent(bucket.getKey(), k -> new ArrayList());
                bucketList.add(bucket);
            }
            SetBackedScalingCuckooFilter otherFilter = ((InternalMappedRareTerms)aggregation).getFilter();
            if (filter == null) {
                filter = new SetBackedScalingCuckooFilter(otherFilter);
                continue;
            }
            filter.merge(otherFilter);
        }
        ArrayList<InternalMultiBucketAggregation.InternalBucket> rare = new ArrayList<InternalMultiBucketAggregation.InternalBucket>();
        for (List sameTermBuckets : buckets.values()) {
            InternalMultiBucketAggregation.InternalBucket b = this.reduceBucket(sameTermBuckets, reduceContext);
            if (((InternalRareTerms.Bucket)b).getDocCount() <= this.maxDocCount && !this.containsTerm(filter, b)) {
                rare.add(b);
                reduceContext.consumeBucketsAndMaybeBreak(1);
                continue;
            }
            if (((InternalRareTerms.Bucket)b).getDocCount() <= this.maxDocCount) continue;
            this.addToFilter(filter, b);
        }
        CollectionUtil.introSort(rare, this.order.comparator());
        return this.createWithFilter(this.name, rare, filter);
    }

    public abstract boolean containsTerm(SetBackedScalingCuckooFilter var1, B var2);

    public abstract void addToFilter(SetBackedScalingCuckooFilter var1, B var2);

    @Override
    public List<B> getBuckets() {
        return this.buckets;
    }

    @Override
    public B getBucketByKey(String term) {
        if (this.bucketMap == null) {
            this.bucketMap = this.buckets.stream().collect(Collectors.toMap(MultiBucketsAggregation.Bucket::getKeyAsString, Function.identity()));
        }
        return (B)((InternalRareTerms.Bucket)this.bucketMap.get(term));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalMappedRareTerms that = (InternalMappedRareTerms)obj;
        return Objects.equals(this.buckets, that.buckets) && Objects.equals(this.format, that.format) && Objects.equals(this.filter, that.filter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buckets, this.format, this.filter);
    }

    @Override
    public final XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return InternalMappedRareTerms.doXContentCommon(builder, params, this.buckets);
    }
}

