/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.DocValueFormat;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.BucketOrder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalAggregations;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.DoubleTerms;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.InternalMappedTerms;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.InternalTerms;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.Terms;

public class UnsignedLongTerms
extends InternalMappedTerms<UnsignedLongTerms, Bucket> {
    public static final String NAME = "ulterms";

    public UnsignedLongTerms(String name, BucketOrder reduceOrder, BucketOrder order, int requiredSize, long minDocCount, Map<String, Object> metadata, DocValueFormat format, int shardSize, boolean showTermDocCountError, long otherDocCount, List<Bucket> buckets, long docCountError) {
        super(name, reduceOrder, order, requiredSize, minDocCount, metadata, format, shardSize, showTermDocCountError, otherDocCount, buckets, docCountError);
    }

    public UnsignedLongTerms(StreamInput in) throws IOException {
        super(in, Bucket::new);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public UnsignedLongTerms create(List<Bucket> buckets) {
        return new UnsignedLongTerms(this.name, this.reduceOrder, this.order, this.requiredSize, this.minDocCount, (Map<String, Object>)this.metadata, this.format, this.shardSize, this.showTermDocCountError, this.otherDocCount, buckets, this.docCountError);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.term, prototype.docCount, aggregations, prototype.showDocCountError, prototype.docCountError, prototype.format);
    }

    @Override
    protected UnsignedLongTerms create(String name, List<Bucket> buckets, BucketOrder reduceOrder, long docCountError, long otherDocCount) {
        return new UnsignedLongTerms(name, reduceOrder, this.order, this.requiredSize, this.minDocCount, this.getMetadata(), this.format, this.shardSize, this.showTermDocCountError, otherDocCount, buckets, docCountError);
    }

    protected Bucket[] createBucketsArray(int size) {
        return new Bucket[size];
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        boolean unsignedLongFormat = false;
        boolean rawFormat = false;
        for (InternalAggregation agg : aggregations) {
            if (agg instanceof DoubleTerms) {
                return agg.reduce(aggregations, reduceContext);
            }
            if (!(agg instanceof UnsignedLongTerms)) continue;
            if (((UnsignedLongTerms)agg).format == DocValueFormat.RAW) {
                rawFormat = true;
                continue;
            }
            if (((UnsignedLongTerms)agg).format == DocValueFormat.UNSIGNED_LONG_SHIFTED) {
                unsignedLongFormat = true;
                continue;
            }
            if (((UnsignedLongTerms)agg).format != DocValueFormat.UNSIGNED_LONG) continue;
            unsignedLongFormat = true;
        }
        if (rawFormat && unsignedLongFormat) {
            ArrayList<InternalAggregation> newAggs = new ArrayList<InternalAggregation>(aggregations.size());
            for (InternalAggregation agg : aggregations) {
                if (agg instanceof UnsignedLongTerms) {
                    DoubleTerms dTerms = UnsignedLongTerms.convertUnsignedLongTermsToDouble((UnsignedLongTerms)agg, this.format);
                    newAggs.add(dTerms);
                    continue;
                }
                newAggs.add(agg);
            }
            return ((InternalAggregation)newAggs.get(0)).reduce(newAggs, reduceContext);
        }
        return super.reduce(aggregations, reduceContext);
    }

    @Override
    Bucket createBucket(long docCount, InternalAggregations aggs, long docCountError, Bucket prototype) {
        return new Bucket(prototype.term, docCount, aggs, prototype.showDocCountError, docCountError, this.format);
    }

    static DoubleTerms convertUnsignedLongTermsToDouble(UnsignedLongTerms unsignedLongTerms, DocValueFormat decimalFormat) {
        List buckets = unsignedLongTerms.getBuckets();
        ArrayList<DoubleTerms.Bucket> newBuckets = new ArrayList<DoubleTerms.Bucket>();
        for (Terms.Bucket bucket : buckets) {
            newBuckets.add(new DoubleTerms.Bucket(bucket.getKeyAsNumber().doubleValue(), bucket.getDocCount(), (InternalAggregations)bucket.getAggregations(), unsignedLongTerms.showTermDocCountError, unsignedLongTerms.showTermDocCountError ? bucket.getDocCountError() : 0L, decimalFormat));
        }
        return new DoubleTerms(unsignedLongTerms.getName(), unsignedLongTerms.reduceOrder, unsignedLongTerms.order, unsignedLongTerms.requiredSize, unsignedLongTerms.minDocCount, (Map<String, Object>)unsignedLongTerms.metadata, unsignedLongTerms.format, unsignedLongTerms.shardSize, unsignedLongTerms.showTermDocCountError, unsignedLongTerms.otherDocCount, (List<DoubleTerms.Bucket>)newBuckets, unsignedLongTerms.docCountError);
    }

    public static class Bucket
    extends InternalTerms.Bucket<Bucket> {
        BigInteger term;

        public Bucket(BigInteger term, long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError, DocValueFormat format) {
            super(docCount, aggregations, showDocCountError, docCountError, format);
            this.term = term;
        }

        public Bucket(StreamInput in, DocValueFormat format, boolean showDocCountError) throws IOException {
            super(in, format, showDocCountError);
            this.term = in.readBigInteger();
        }

        @Override
        protected void writeTermTo(StreamOutput out) throws IOException {
            out.writeBigInteger(this.term);
        }

        @Override
        public String getKeyAsString() {
            return this.format.format(this.term).toString();
        }

        @Override
        public Object getKey() {
            if (this.format == DocValueFormat.UNSIGNED_LONG_SHIFTED) {
                return this.format.format(this.term);
            }
            return this.term;
        }

        @Override
        public Number getKeyAsNumber() {
            if (this.format == DocValueFormat.UNSIGNED_LONG_SHIFTED) {
                return this.format.format(this.term);
            }
            return this.term;
        }

        @Override
        public int compareKey(Bucket other) {
            return this.term.compareTo(other.term);
        }

        @Override
        protected final XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            if (this.format == DocValueFormat.UNSIGNED_LONG_SHIFTED) {
                builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.format.format(this.term));
            } else {
                builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.term);
            }
            if (this.format != DocValueFormat.RAW && this.format != DocValueFormat.UNSIGNED_LONG_SHIFTED && this.format != DocValueFormat.UNSIGNED_LONG) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), this.format.format(this.term).toString());
            }
            return builder;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.equals(this.term, ((Bucket)obj).term);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.term);
        }
    }
}

