/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.heuristic;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchParseException;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardException;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristicBuilder;

public class PercentageScore
extends SignificanceHeuristic {
    public static final String NAME = "percentage";
    public static final ObjectParser<PercentageScore, Void> PARSER = new ObjectParser("percentage", PercentageScore::new);

    public PercentageScore() {
    }

    public PercentageScore(StreamInput in) {
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME).endObject();
        return builder;
    }

    public static SignificanceHeuristic parse(XContentParser parser) throws IOException, QueryShardException {
        if (!parser.nextToken().equals((Object)XContentParser.Token.END_OBJECT)) {
            throw new OpenSearchParseException("failed to parse [percentage] significance heuristic. expected an empty object, but got [{}] instead", new Object[]{parser.currentToken()});
        }
        return new PercentageScore();
    }

    @Override
    public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
        this.checkFrequencyValidity(subsetFreq, subsetSize, supersetFreq, supersetSize, "PercentageScore");
        if (supersetFreq == 0L) {
            return 0.0;
        }
        return (double)subsetFreq / (double)supersetFreq;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class PercentageScoreBuilder
    implements SignificanceHeuristicBuilder {
        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(PercentageScore.NAME).endObject();
            return builder;
        }
    }
}

