/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.HdrHistogram.DoubleHistogram;
import org.graylog.shaded.opensearch2.org.opensearch.search.DocValueFormat;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.AbstractHDRPercentilesAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalHDRPercentiles;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.SearchContext;

class HDRPercentilesAggregator
extends AbstractHDRPercentilesAggregator {
    HDRPercentilesAggregator(String name, ValuesSource valuesSource, SearchContext context, Aggregator parent, double[] percents, int numberOfSignificantValueDigits, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
        super(name, valuesSource, context, parent, percents, numberOfSignificantValueDigits, keyed, formatter, metadata);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        DoubleHistogram state = this.getState(owningBucketOrdinal);
        if (state == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalHDRPercentiles(this.name, this.keys, state, this.keyed, this.format, this.metadata());
    }

    @Override
    public double metric(String name, long bucketOrd) {
        DoubleHistogram state = this.getState(bucketOrd);
        if (state == null) {
            return Double.NaN;
        }
        return state.getValueAtPercentile(Double.parseDouble(name));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        DoubleHistogram state = new DoubleHistogram(this.numberOfSignificantValueDigits);
        state.setAutoResize(true);
        return new InternalHDRPercentiles(this.name, this.keys, state, this.keyed, this.format, this.metadata());
    }
}

