/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.FieldDoc;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreDoc;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Sort;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopFieldDocs;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TotalHits;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.Lucene;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.search.TopDocsAndMaxScore;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchHit;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchHits;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.TopHits;

public class InternalTopHits
extends InternalAggregation
implements TopHits {
    private int from;
    private int size;
    private TopDocsAndMaxScore topDocs;
    private SearchHits searchHits;

    public InternalTopHits(String name, int from, int size, TopDocsAndMaxScore topDocs, SearchHits searchHits, Map<String, Object> metadata) {
        super(name, metadata);
        this.from = from;
        this.size = size;
        this.topDocs = topDocs;
        this.searchHits = searchHits;
    }

    public InternalTopHits(StreamInput in) throws IOException {
        super(in);
        this.from = in.readVInt();
        this.size = in.readVInt();
        this.topDocs = Lucene.readTopDocs(in);
        this.searchHits = new SearchHits(in);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.from);
        out.writeVInt(this.size);
        Lucene.writeTopDocs(out, this.topDocs);
        this.searchHits.writeTo(out);
    }

    @Override
    public String getWriteableName() {
        return "top_hits";
    }

    @Override
    public SearchHits getHits() {
        return this.searchHits;
    }

    TopDocsAndMaxScore getTopDocs() {
        return this.topDocs;
    }

    int getFrom() {
        return this.from;
    }

    int getSize() {
        return this.size;
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        TopDocs reducedTopDocs;
        TopDocs[] shardDocs;
        int size;
        int from;
        SearchHits[] shardHits = new SearchHits[aggregations.size()];
        if (reduceContext.isFinalReduce()) {
            from = this.from;
            size = this.size;
        } else {
            from = 0;
            size = this.from + this.size;
        }
        if (this.topDocs.topDocs instanceof TopFieldDocs) {
            Sort sort = new Sort(((TopFieldDocs)this.topDocs.topDocs).fields);
            shardDocs = new TopFieldDocs[aggregations.size()];
            for (int i = 0; i < shardDocs.length; ++i) {
                ScoreDoc[] topHitsAgg = (ScoreDoc[])aggregations.get(i);
                shardDocs[i] = topHitsAgg.topDocs.topDocs;
                shardHits[i] = topHitsAgg.searchHits;
                for (ScoreDoc doc : shardDocs[i].scoreDocs) {
                    doc.shardIndex = i;
                }
            }
            reducedTopDocs = TopDocs.merge(sort, from, size, (TopFieldDocs[])shardDocs);
        } else {
            shardDocs = new TopDocs[aggregations.size()];
            for (int i = 0; i < shardDocs.length; ++i) {
                InternalTopHits topHitsAgg = (InternalTopHits)aggregations.get(i);
                shardDocs[i] = topHitsAgg.topDocs.topDocs;
                shardHits[i] = topHitsAgg.searchHits;
                for (ScoreDoc doc : shardDocs[i].scoreDocs) {
                    doc.shardIndex = i;
                }
            }
            reducedTopDocs = TopDocs.merge(from, size, shardDocs);
        }
        float maxScore = Float.NaN;
        for (InternalAggregation agg : aggregations) {
            InternalTopHits topHitsAgg = (InternalTopHits)agg;
            if (Float.isNaN(topHitsAgg.topDocs.maxScore)) continue;
            if (Float.isNaN(maxScore)) {
                maxScore = topHitsAgg.topDocs.maxScore;
                continue;
            }
            maxScore = Math.max(maxScore, topHitsAgg.topDocs.maxScore);
        }
        int[] tracker = new int[shardHits.length];
        SearchHit[] hits = new SearchHit[reducedTopDocs.scoreDocs.length];
        for (int i = 0; i < reducedTopDocs.scoreDocs.length; ++i) {
            int position;
            ScoreDoc scoreDoc = reducedTopDocs.scoreDocs[i];
            do {
                int n = scoreDoc.shardIndex;
                tracker[n] = tracker[n] + 1;
            } while (shardDocs[scoreDoc.shardIndex].scoreDocs[position] != scoreDoc);
            hits[i] = shardHits[scoreDoc.shardIndex].getAt(position);
        }
        assert (reducedTopDocs.totalHits.relation == TotalHits.Relation.EQUAL_TO);
        return new InternalTopHits(this.name, this.from, this.size, new TopDocsAndMaxScore(reducedTopDocs, maxScore), new SearchHits(hits, reducedTopDocs.totalHits, maxScore), this.getMetadata());
    }

    @Override
    protected boolean mustReduceOnSingleInternalAgg() {
        return true;
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.searchHits.toXContent(builder, params);
        return builder;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalTopHits other = (InternalTopHits)obj;
        if (this.from != other.from) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.topDocs.topDocs.totalHits.value != other.topDocs.topDocs.totalHits.value) {
            return false;
        }
        if (this.topDocs.topDocs.totalHits.relation != other.topDocs.topDocs.totalHits.relation) {
            return false;
        }
        if (this.topDocs.topDocs.scoreDocs.length != other.topDocs.topDocs.scoreDocs.length) {
            return false;
        }
        for (int d = 0; d < this.topDocs.topDocs.scoreDocs.length; ++d) {
            ScoreDoc thisDoc = this.topDocs.topDocs.scoreDocs[d];
            ScoreDoc otherDoc = other.topDocs.topDocs.scoreDocs[d];
            if (thisDoc.doc != otherDoc.doc) {
                return false;
            }
            if (Double.compare(thisDoc.score, otherDoc.score) != 0) {
                return false;
            }
            if (thisDoc.shardIndex != otherDoc.shardIndex) {
                return false;
            }
            if (!(thisDoc instanceof FieldDoc)) continue;
            if (!(otherDoc instanceof FieldDoc)) {
                return false;
            }
            FieldDoc thisFieldDoc = (FieldDoc)thisDoc;
            FieldDoc otherFieldDoc = (FieldDoc)otherDoc;
            if (thisFieldDoc.fields.length != otherFieldDoc.fields.length) {
                return false;
            }
            for (int f = 0; f < thisFieldDoc.fields.length; ++f) {
                if (thisFieldDoc.fields[f].equals(otherFieldDoc.fields[f])) continue;
                return false;
            }
        }
        return this.searchHits.equals(other.searchHits);
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = 31 * hashCode + Integer.hashCode(this.from);
        hashCode = 31 * hashCode + Integer.hashCode(this.size);
        hashCode = 31 * hashCode + Long.hashCode(this.topDocs.topDocs.totalHits.value);
        hashCode = 31 * hashCode + this.topDocs.topDocs.totalHits.relation.hashCode();
        for (int d = 0; d < this.topDocs.topDocs.scoreDocs.length; ++d) {
            ScoreDoc doc = this.topDocs.topDocs.scoreDocs[d];
            hashCode = 31 * hashCode + doc.doc;
            hashCode = 31 * hashCode + Float.floatToIntBits(doc.score);
            hashCode = 31 * hashCode + doc.shardIndex;
            if (!(doc instanceof FieldDoc)) continue;
            FieldDoc fieldDoc = (FieldDoc)doc;
            hashCode = 31 * hashCode + Arrays.hashCode(fieldDoc.fields);
        }
        hashCode = 31 * hashCode + this.searchHits.hashCode();
        return hashCode;
    }
}

