/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.LongAdder;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.node.ReportingService;

public class AggregationInfo
implements ReportingService.Info {
    private final Map<String, Set<String>> aggs;

    AggregationInfo(Map<String, Map<String, LongAdder>> aggs) {
        TreeMap aggsMap = new TreeMap();
        aggs.forEach((s, m) -> aggsMap.put(s, Collections.unmodifiableSet(new TreeSet(m.keySet()))));
        this.aggs = Collections.unmodifiableMap(aggsMap);
    }

    public AggregationInfo(StreamInput in) throws IOException {
        this.aggs = new TreeMap<String, Set<String>>();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            int keys = in.readVInt();
            TreeSet<String> types = new TreeSet<String>();
            for (int j = 0; j < keys; ++j) {
                types.add(in.readString());
            }
            this.aggs.put(key, types);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.aggs.size());
        for (Map.Entry<String, Set<String>> e : this.aggs.entrySet()) {
            out.writeString(e.getKey());
            out.writeVInt(e.getValue().size());
            for (String type : e.getValue()) {
                out.writeString(type);
            }
        }
    }

    public Map<String, Set<String>> getAggregations() {
        return this.aggs;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("aggregations");
        for (Map.Entry<String, Set<String>> e : this.aggs.entrySet()) {
            builder.startObject(e.getKey());
            builder.startArray("types");
            for (String s : e.getValue()) {
                builder.value(s);
            }
            builder.endArray();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregationInfo that = (AggregationInfo)o;
        return Objects.equals(this.aggs, that.aggs);
    }

    public int hashCode() {
        return Objects.hash(this.aggs);
    }
}

