/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.opensearch.common.regex.Regex;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.SourceFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.FetchContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.FetchSubPhase;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.FetchSubPhaseProcessor;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.highlight.FieldHighlightContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.highlight.HighlightField;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.highlight.Highlighter;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.highlight.SearchHighlightContext;

public class HighlightPhase
implements FetchSubPhase {
    private final Map<String, Highlighter> highlighters;

    public HighlightPhase(Map<String, Highlighter> highlighters) {
        this.highlighters = highlighters;
    }

    @Override
    public FetchSubPhaseProcessor getProcessor(FetchContext context) {
        if (context.highlight() == null) {
            return null;
        }
        return this.getProcessor(context, context.highlight(), context.parsedQuery().query());
    }

    public FetchSubPhaseProcessor getProcessor(FetchContext context, SearchHighlightContext highlightContext, Query query) {
        HashMap<String, Object> sharedCache = new HashMap<String, Object>();
        final Map<String, Function<FetchSubPhase.HitContext, FieldHighlightContext>> contextBuilders = this.contextBuilders(context, highlightContext, query, sharedCache);
        return new FetchSubPhaseProcessor(){

            @Override
            public void setNextReader(LeafReaderContext readerContext) {
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) throws IOException {
                HashMap<String, HighlightField> highlightFields = new HashMap<String, HighlightField>();
                for (String field : contextBuilders.keySet()) {
                    FieldHighlightContext fieldContext = (FieldHighlightContext)((Function)contextBuilders.get(field)).apply(hitContext);
                    Highlighter highlighter = HighlightPhase.this.getHighlighter(fieldContext.field);
                    HighlightField highlightField = highlighter.highlight(fieldContext);
                    if (highlightField == null) continue;
                    highlightFields.put(field, new HighlightField(field, highlightField.fragments()));
                }
                hitContext.hit().highlightFields(highlightFields);
            }
        };
    }

    private Highlighter getHighlighter(SearchHighlightContext.Field field) {
        Highlighter highlighter;
        String highlighterType = field.fieldOptions().highlighterType();
        if (highlighterType == null) {
            highlighterType = "unified";
        }
        if ((highlighter = this.highlighters.get(highlighterType)) == null) {
            throw new IllegalArgumentException("unknown highlighter type [" + highlighterType + "] for the field [" + field.field() + "]");
        }
        return highlighter;
    }

    private Map<String, Function<FetchSubPhase.HitContext, FieldHighlightContext>> contextBuilders(FetchContext context, SearchHighlightContext highlightContext, Query query, Map<String, Object> sharedCache) {
        LinkedHashMap<String, Function<FetchSubPhase.HitContext, FieldHighlightContext>> builders = new LinkedHashMap<String, Function<FetchSubPhase.HitContext, FieldHighlightContext>>();
        for (SearchHighlightContext.Field field : highlightContext.fields()) {
            SourceFieldMapper sourceFieldMapper;
            Highlighter highlighter = this.getHighlighter(field);
            Collection<String> fieldNamesToHighlight = Regex.isSimpleMatchPattern(field.field()) ? context.mapperService().simpleMatchToFullName(field.field()) : Collections.singletonList(field.field());
            if (highlightContext.forceSource(field) && !(sourceFieldMapper = context.mapperService().documentMapper().sourceMapper()).enabled()) {
                throw new IllegalArgumentException("source is forced for fields " + fieldNamesToHighlight + " but _source is disabled");
            }
            boolean fieldNameContainsWildcards = field.field().contains("*");
            for (String fieldName : fieldNamesToHighlight) {
                MappedFieldType fieldType = context.mapperService().fieldType(fieldName);
                if (fieldType == null || fieldNameContainsWildcards && (!fieldType.typeName().equals("text") && !fieldType.typeName().equals("keyword") || !highlighter.canHighlight(fieldType))) continue;
                Query highlightQuery = field.fieldOptions().highlightQuery();
                boolean forceSource = highlightContext.forceSource(field);
                builders.put(fieldName, hc -> new FieldHighlightContext(fieldType.name(), field, fieldType, context, (FetchSubPhase.HitContext)hc, highlightQuery == null ? query : highlightQuery, forceSource, sharedCache));
            }
        }
        return builders;
    }
}

