/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.lookup;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchParseException;
import org.graylog.shaded.opensearch2.org.opensearch.common.CheckedBiConsumer;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.index.SequentialStoredFieldsLeafReader;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentHelper;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentType;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.support.XContentMapValues;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaType;
import org.graylog.shaded.opensearch2.org.opensearch.index.fieldvisitor.FieldsVisitor;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.FetchSourceContext;

public class SourceLookup
implements Map {
    private LeafReader reader;
    CheckedBiConsumer<Integer, FieldsVisitor, IOException> fieldReader;
    private int docId = -1;
    private BytesReference sourceAsBytes;
    private Map<String, Object> source;
    private MediaType sourceContentType;

    public Map<String, Object> source() {
        return this.source;
    }

    public XContentType sourceContentType() {
        return XContentType.fromMediaType(this.sourceContentType);
    }

    public int docId() {
        return this.docId;
    }

    public Map<String, Object> loadSourceIfNeeded() {
        if (this.source != null) {
            return this.source;
        }
        if (this.sourceAsBytes != null) {
            Tuple<XContentType, Map<String, Object>> tuple = SourceLookup.sourceAsMapAndType(this.sourceAsBytes);
            this.sourceContentType = tuple.v1();
            this.source = tuple.v2();
            return this.source;
        }
        try {
            FieldsVisitor sourceFieldVisitor = new FieldsVisitor(true);
            this.fieldReader.accept(this.docId, sourceFieldVisitor);
            BytesReference source = sourceFieldVisitor.source();
            if (source == null) {
                this.source = Collections.emptyMap();
                this.sourceContentType = null;
            } else {
                Tuple<XContentType, Map<String, Object>> tuple = SourceLookup.sourceAsMapAndType(source);
                this.sourceContentType = tuple.v1();
                this.source = tuple.v2();
            }
        }
        catch (Exception e) {
            throw new OpenSearchParseException("failed to parse / load source", (Throwable)e, new Object[0]);
        }
        return this.source;
    }

    private static Tuple<XContentType, Map<String, Object>> sourceAsMapAndType(BytesReference source) throws OpenSearchParseException {
        return XContentHelper.convertToMap(source, false);
    }

    public static Map<String, Object> sourceAsMap(BytesReference source) throws OpenSearchParseException {
        return SourceLookup.sourceAsMapAndType(source).v2();
    }

    public void setSegmentAndDocument(LeafReaderContext context, int docId) {
        if (this.reader == context.reader() && this.docId == docId) {
            return;
        }
        if (this.reader != context.reader()) {
            this.reader = context.reader();
            try {
                if (context.reader() instanceof SequentialStoredFieldsLeafReader) {
                    SequentialStoredFieldsLeafReader lf = (SequentialStoredFieldsLeafReader)context.reader();
                    this.fieldReader = lf.getSequentialStoredFieldsReader()::document;
                } else {
                    this.fieldReader = context.reader()::document;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        this.source = null;
        this.sourceAsBytes = null;
        this.docId = docId;
    }

    public void setSource(BytesReference source) {
        this.sourceAsBytes = source;
    }

    public void setSourceContentType(XContentType sourceContentType) {
        this.sourceContentType = sourceContentType;
    }

    public void setSource(Map<String, Object> source) {
        this.source = source;
    }

    public BytesReference internalSourceRef() {
        return this.sourceAsBytes;
    }

    public List<Object> extractRawValues(String path) {
        return XContentMapValues.extractRawValues(path, this.loadSourceIfNeeded());
    }

    public Object extractValue(String path, @Nullable Object nullValue) {
        return XContentMapValues.extractValue(path, this.loadSourceIfNeeded(), nullValue);
    }

    public Object filter(FetchSourceContext context) {
        return context.getFilter().apply(this.loadSourceIfNeeded());
    }

    public Object get(Object key) {
        return this.loadSourceIfNeeded().get(key);
    }

    @Override
    public int size() {
        return this.loadSourceIfNeeded().size();
    }

    @Override
    public boolean isEmpty() {
        return this.loadSourceIfNeeded().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.loadSourceIfNeeded().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.loadSourceIfNeeded().containsValue(value);
    }

    public Set keySet() {
        return this.loadSourceIfNeeded().keySet();
    }

    public Collection values() {
        return this.loadSourceIfNeeded().values();
    }

    public Set entrySet() {
        return this.loadSourceIfNeeded().entrySet();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

