/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.pipeline;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.node.ReportingService;
import org.graylog.shaded.opensearch2.org.opensearch.search.pipeline.ProcessorInfo;

public class SearchPipelineInfo
implements ReportingService.Info {
    private final Map<String, Set<ProcessorInfo>> processors = new TreeMap<String, Set<ProcessorInfo>>();

    public SearchPipelineInfo(Map<String, List<ProcessorInfo>> processors) {
        for (Map.Entry<String, List<ProcessorInfo>> processorsEntry : processors.entrySet()) {
            this.processors.put(processorsEntry.getKey(), new TreeSet(processorsEntry.getValue()));
        }
    }

    public SearchPipelineInfo(StreamInput in) throws IOException {
        if (in.getVersion().before(Version.V_2_8_0)) {
            int size = in.readVInt();
            TreeSet<ProcessorInfo> processorInfos = new TreeSet<ProcessorInfo>();
            for (int i = 0; i < size; ++i) {
                processorInfos.add(new ProcessorInfo(in));
            }
            this.processors.put("request_processors", processorInfos);
            this.processors.put("response_processors", processorInfos);
        } else {
            int numTypes = in.readVInt();
            for (int i = 0; i < numTypes; ++i) {
                String type = in.readString();
                int numProcessors = in.readVInt();
                TreeSet<ProcessorInfo> processorInfos = new TreeSet<ProcessorInfo>();
                for (int j = 0; j < numProcessors; ++j) {
                    processorInfos.add(new ProcessorInfo(in));
                }
                this.processors.put(type, processorInfos);
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("search_pipelines");
        for (Map.Entry<String, Set<ProcessorInfo>> processorEntry : this.processors.entrySet()) {
            builder.startArray(processorEntry.getKey());
            for (ProcessorInfo info : processorEntry.getValue()) {
                info.toXContent(builder, params);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_2_8_0)) {
            TreeSet processorInfos = new TreeSet();
            processorInfos.addAll(this.processors.getOrDefault("request_processors", Collections.emptySet()));
            processorInfos.addAll(this.processors.getOrDefault("response_processors", Collections.emptySet()));
            out.writeVInt(processorInfos.size());
            for (ProcessorInfo processorInfo : processorInfos) {
                processorInfo.writeTo(out);
            }
        } else {
            out.write(this.processors.size());
            for (Map.Entry<String, Set<ProcessorInfo>> processorsEntry : this.processors.entrySet()) {
                out.writeString(processorsEntry.getKey());
                out.writeVInt(processorsEntry.getValue().size());
                for (ProcessorInfo processorInfo : processorsEntry.getValue()) {
                    processorInfo.writeTo(out);
                }
            }
        }
    }

    public boolean containsProcessor(String processorType, String type) {
        return this.processors.containsKey(processorType) && this.processors.get(processorType).contains(new ProcessorInfo(type));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchPipelineInfo that = (SearchPipelineInfo)o;
        return Objects.equals(this.processors, that.processors);
    }

    public int hashCode() {
        return Objects.hash(this.processors);
    }
}

