/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.snapshots;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.Snapshot;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.SnapshotId;

public class SnapshotException
extends OpenSearchException {
    @Nullable
    private final String repositoryName;
    @Nullable
    private final String snapshotName;

    public SnapshotException(Snapshot snapshot, String msg) {
        this(snapshot, msg, null);
    }

    public SnapshotException(Snapshot snapshot, String msg, Throwable cause) {
        super("[" + (snapshot == null ? "_na" : snapshot) + "] " + msg, cause, new Object[0]);
        if (snapshot != null) {
            this.repositoryName = snapshot.getRepository();
            this.snapshotName = snapshot.getSnapshotId().getName();
        } else {
            this.repositoryName = null;
            this.snapshotName = null;
        }
    }

    public SnapshotException(String repositoryName, SnapshotId snapshotId, String msg, Throwable cause) {
        super("[" + repositoryName + ":" + snapshotId + "] " + msg, cause, new Object[0]);
        this.repositoryName = repositoryName;
        this.snapshotName = snapshotId.getName();
    }

    public SnapshotException(String repositoryName, String snapshotName, String msg) {
        this(repositoryName, snapshotName, msg, null);
    }

    public SnapshotException(String repositoryName, String snapshotName, String msg, Throwable cause) {
        super("[" + repositoryName + ":" + snapshotName + "] " + msg, cause, new Object[0]);
        this.repositoryName = repositoryName;
        this.snapshotName = snapshotName;
    }

    public SnapshotException(StreamInput in) throws IOException {
        super(in);
        this.repositoryName = in.readOptionalString();
        this.snapshotName = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.repositoryName);
        out.writeOptionalString(this.snapshotName);
    }

    @Nullable
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Nullable
    public String getSnapshotName() {
        return this.snapshotName;
    }
}

