/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.tasks;

import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.SetOnce;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchService;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.Task;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.TaskId;

public abstract class CancellableTask
extends Task {
    private final SetOnce<CancelledInfo> cancelledInfo = new SetOnce();
    private final TimeValue cancelAfterTimeInterval;

    public CancellableTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers) {
        this(id, type, action, description, parentTaskId, headers, SearchService.NO_TIMEOUT);
    }

    public CancellableTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers, TimeValue cancelAfterTimeInterval) {
        super(id, type, action, description, parentTaskId, headers);
        this.cancelAfterTimeInterval = cancelAfterTimeInterval;
    }

    public void cancel(String reason) {
        assert (reason != null);
        if (this.cancelledInfo.trySet(new CancelledInfo(reason))) {
            this.onCancelled();
        }
    }

    public boolean isCancelled() {
        return this.cancelledInfo.get() != null;
    }

    public abstract boolean shouldCancelChildrenOnCancellation();

    public TimeValue getCancellationTimeout() {
        return this.cancelAfterTimeInterval;
    }

    protected void onCancelled() {
    }

    public boolean cancelOnParentLeaving() {
        return true;
    }

    @Nullable
    public Long getCancellationStartTime() {
        CancelledInfo info = this.cancelledInfo.get();
        return info != null ? info.cancellationStartTime : null;
    }

    @Nullable
    public Long getCancellationStartTimeNanos() {
        CancelledInfo info = this.cancelledInfo.get();
        return info != null ? info.cancellationStartTimeNanos : null;
    }

    @Nullable
    public String getReasonCancelled() {
        CancelledInfo info = this.cancelledInfo.get();
        return info != null ? info.reason : null;
    }

    private static class CancelledInfo {
        String reason;
        Long cancellationStartTime;
        Long cancellationStartTimeNanos;

        public CancelledInfo(String reason) {
            this.reason = reason;
            this.cancellationStartTime = System.currentTimeMillis();
            this.cancellationStartTimeNanos = System.nanoTime();
        }
    }
}

