/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.DefaultSpanScope;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.Span;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.SpanScope;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.Tracer;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.TracerContextStorage;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.TracingTelemetry;

class DefaultTracer
implements Tracer {
    static final String THREAD_NAME = "th_name";
    private final TracingTelemetry tracingTelemetry;
    private final TracerContextStorage<String, Span> tracerContextStorage;

    public DefaultTracer(TracingTelemetry tracingTelemetry, TracerContextStorage<String, Span> tracerContextStorage) {
        this.tracingTelemetry = tracingTelemetry;
        this.tracerContextStorage = tracerContextStorage;
    }

    @Override
    public SpanScope startSpan(String spanName) {
        Span span = this.createSpan(spanName, this.getCurrentSpan());
        this.setCurrentSpanInContext(span);
        this.addDefaultAttributes(span);
        return new DefaultSpanScope(span, scopeSpan -> this.endSpan((Span)scopeSpan));
    }

    @Override
    public void close() throws IOException {
        this.tracingTelemetry.close();
    }

    Span getCurrentSpan() {
        return this.tracerContextStorage.get("current_span");
    }

    private void endSpan(Span span) {
        if (span != null) {
            span.endSpan();
            this.setCurrentSpanInContext(span.getParentSpan());
        }
    }

    private Span createSpan(String spanName, Span parentSpan) {
        return this.tracingTelemetry.createSpan(spanName, parentSpan);
    }

    private void setCurrentSpanInContext(Span span) {
        this.tracerContextStorage.put("current_span", span);
    }

    protected void addDefaultAttributes(Span span) {
        span.addAttribute(THREAD_NAME, Thread.currentThread().getName());
    }
}

