/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.TelemetrySettings;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.SpanScope;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.Tracer;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.noop.NoopTracer;

final class WrappedTracer
implements Tracer {
    private final Tracer defaultTracer;
    private final TelemetrySettings telemetrySettings;

    public WrappedTracer(TelemetrySettings telemetrySettings, Tracer defaultTracer) {
        this.defaultTracer = defaultTracer;
        this.telemetrySettings = telemetrySettings;
    }

    @Override
    public SpanScope startSpan(String spanName) {
        Tracer delegateTracer = this.getDelegateTracer();
        return delegateTracer.startSpan(spanName);
    }

    @Override
    public void close() throws IOException {
        this.defaultTracer.close();
    }

    Tracer getDelegateTracer() {
        return this.telemetrySettings.isTracingEnabled() ? this.defaultTracer : NoopTracer.INSTANCE;
    }
}

