/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.NotifyOnceListener;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.common.CheckedSupplier;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.ReleasableBytesStreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasable;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasables;
import org.graylog.shaded.opensearch2.org.opensearch.common.network.CloseableChannel;
import org.graylog.shaded.opensearch2.org.opensearch.common.transport.NetworkExceptionHelper;
import org.graylog.shaded.opensearch2.org.opensearch.common.transport.TransportAddress;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.BigArrays;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ThreadContext;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.io.IOUtils;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.OutboundMessage;
import org.graylog.shaded.opensearch2.org.opensearch.transport.RemoteTransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.StatsTracker;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TcpChannel;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportLogger;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportMessageListener;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequest;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequestOptions;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportResponse;

final class OutboundHandler {
    private static final Logger logger = LogManager.getLogger(OutboundHandler.class);
    private final String nodeName;
    private final Version version;
    private final String[] features;
    private final StatsTracker statsTracker;
    private final ThreadPool threadPool;
    private final BigArrays bigArrays;
    private volatile TransportMessageListener messageListener = TransportMessageListener.NOOP_LISTENER;

    OutboundHandler(String nodeName, Version version, String[] features, StatsTracker statsTracker, ThreadPool threadPool, BigArrays bigArrays) {
        this.nodeName = nodeName;
        this.version = version;
        this.features = features;
        this.statsTracker = statsTracker;
        this.threadPool = threadPool;
        this.bigArrays = bigArrays;
    }

    void sendBytes(TcpChannel channel, BytesReference bytes, ActionListener<Void> listener) {
        SendContext sendContext = new SendContext(channel, () -> bytes, listener);
        try {
            this.internalSend(channel, sendContext);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    void sendRequest(DiscoveryNode node, TcpChannel channel, long requestId, String action, TransportRequest request, TransportRequestOptions options, Version channelVersion, boolean compressRequest, boolean isHandshake) throws IOException, TransportException {
        Version version = Version.min(this.version, channelVersion);
        OutboundMessage.Request message = new OutboundMessage.Request(this.threadPool.getThreadContext(), this.features, request, version, action, requestId, isHandshake, compressRequest);
        ActionListener<Void> listener = ActionListener.wrap(() -> this.messageListener.onRequestSent(node, requestId, action, request, options));
        this.sendMessage(channel, message, listener);
    }

    void sendResponse(Version nodeVersion, Set<String> features, TcpChannel channel, long requestId, String action, TransportResponse response, boolean compress, boolean isHandshake) throws IOException {
        Version version = Version.min(this.version, nodeVersion);
        OutboundMessage.Response message = new OutboundMessage.Response(this.threadPool.getThreadContext(), features, response, version, requestId, isHandshake, compress);
        ActionListener<Void> listener = ActionListener.wrap(() -> this.messageListener.onResponseSent(requestId, action, response));
        this.sendMessage(channel, message, listener);
    }

    void sendErrorResponse(Version nodeVersion, Set<String> features, TcpChannel channel, long requestId, String action, Exception error) throws IOException {
        Version version = Version.min(this.version, nodeVersion);
        TransportAddress address = new TransportAddress(channel.getLocalAddress());
        RemoteTransportException tx = new RemoteTransportException(this.nodeName, address, action, error);
        OutboundMessage.Response message = new OutboundMessage.Response(this.threadPool.getThreadContext(), features, tx, version, requestId, false, false);
        ActionListener<Void> listener = ActionListener.wrap(() -> this.messageListener.onResponseSent(requestId, action, error));
        this.sendMessage(channel, message, listener);
    }

    private void sendMessage(TcpChannel channel, OutboundMessage networkMessage, ActionListener<Void> listener) throws IOException {
        MessageSerializer serializer = new MessageSerializer(networkMessage, this.bigArrays);
        SendContext sendContext = new SendContext(channel, serializer, listener, serializer);
        this.internalSend(channel, sendContext);
    }

    private void internalSend(TcpChannel channel, SendContext sendContext) throws IOException {
        channel.getChannelStats().markAccessed(this.threadPool.relativeTimeInMillis());
        BytesReference reference = sendContext.get();
        try (ThreadContext.StoredContext existing = this.threadPool.getThreadContext().stashContext();){
            channel.sendMessage(reference, sendContext);
        }
        catch (RuntimeException ex) {
            sendContext.onFailure(ex);
            CloseableChannel.closeChannel(channel);
            throw ex;
        }
    }

    void setMessageListener(TransportMessageListener listener) {
        if (this.messageListener != TransportMessageListener.NOOP_LISTENER) {
            throw new IllegalStateException("Cannot set message listener twice");
        }
        this.messageListener = listener;
    }

    private class SendContext
    extends NotifyOnceListener<Void>
    implements CheckedSupplier<BytesReference, IOException> {
        private final TcpChannel channel;
        private final CheckedSupplier<BytesReference, IOException> messageSupplier;
        private final ActionListener<Void> listener;
        private final Releasable optionalReleasable;
        private long messageSize = -1L;

        private SendContext(TcpChannel channel, CheckedSupplier<BytesReference, IOException> messageSupplier, ActionListener<Void> listener) {
            this(channel, messageSupplier, listener, null);
        }

        private SendContext(TcpChannel channel, CheckedSupplier<BytesReference, IOException> messageSupplier, ActionListener<Void> listener, Releasable optionalReleasable) {
            this.channel = channel;
            this.messageSupplier = messageSupplier;
            this.listener = listener;
            this.optionalReleasable = optionalReleasable;
        }

        @Override
        public BytesReference get() throws IOException {
            try {
                BytesReference message = this.messageSupplier.get();
                this.messageSize = message.length();
                TransportLogger.logOutboundMessage(this.channel, message);
                return message;
            }
            catch (Exception e) {
                this.onFailure(e);
                throw e;
            }
        }

        @Override
        protected void innerOnResponse(Void v) {
            assert (this.messageSize != -1L) : "If onResponse is being called, the message should have been serialized";
            OutboundHandler.this.statsTracker.markBytesWritten(this.messageSize);
            this.closeAndCallback(() -> this.listener.onResponse(v));
        }

        @Override
        protected void innerOnFailure(Exception e) {
            if (NetworkExceptionHelper.isCloseConnectionException(e)) {
                logger.debug(() -> new ParameterizedMessage("send message failed [channel: {}]", (Object)this.channel), (Throwable)e);
            } else {
                logger.warn(() -> new ParameterizedMessage("send message failed [channel: {}]", (Object)this.channel), (Throwable)e);
            }
            this.closeAndCallback(() -> this.listener.onFailure(e));
        }

        private void closeAndCallback(Runnable runnable) {
            Releasable[] releasableArray = new Releasable[2];
            releasableArray[0] = this.optionalReleasable;
            releasableArray[1] = runnable::run;
            Releasables.close(releasableArray);
        }
    }

    private static class MessageSerializer
    implements CheckedSupplier<BytesReference, IOException>,
    Releasable {
        private final OutboundMessage message;
        private final BigArrays bigArrays;
        private volatile ReleasableBytesStreamOutput bytesStreamOutput;

        private MessageSerializer(OutboundMessage message, BigArrays bigArrays) {
            this.message = message;
            this.bigArrays = bigArrays;
        }

        @Override
        public BytesReference get() throws IOException {
            this.bytesStreamOutput = new ReleasableBytesStreamOutput(this.bigArrays);
            return this.message.serialize(this.bytesStreamOutput);
        }

        @Override
        public void close() {
            IOUtils.closeWhileHandlingException((Closeable)this.bytesStreamOutput);
        }
    }
}

