/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.com.carrotsearch.hppc;

import java.util.Arrays;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.FloatCollection;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.FloatLookupContainer;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.cursors.FloatCursor;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.predicates.FloatPredicate;

abstract class AbstractFloatCollection
implements FloatCollection {
    AbstractFloatCollection() {
    }

    @Override
    public int removeAll(final FloatLookupContainer c) {
        return this.removeAll(new FloatPredicate(){

            @Override
            public boolean apply(float k) {
                return c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final FloatLookupContainer c) {
        return this.removeAll(new FloatPredicate(){

            @Override
            public boolean apply(float k) {
                return !c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final FloatPredicate predicate) {
        return this.removeAll(new FloatPredicate(){

            @Override
            public boolean apply(float value) {
                return !predicate.apply(value);
            }
        });
    }

    @Override
    public float[] toArray() {
        float[] array = new float[this.size()];
        int i = 0;
        for (FloatCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

