/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.com.github.mustachejava.resolver;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.graylog.shaded.opensearch2.com.github.mustachejava.MustacheResolver;

public class ClasspathResolver
implements MustacheResolver {
    private final String resourceRoot;

    public ClasspathResolver() {
        this.resourceRoot = null;
    }

    public ClasspathResolver(String resourceRoot) {
        this.resourceRoot = resourceRoot;
    }

    @Override
    public Reader getReader(String resourceName) {
        String fullResourceName;
        String normalizeResourceName;
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        InputStream is = ccl.getResourceAsStream(normalizeResourceName = URI.create(fullResourceName = this.concatResourceRootAndResourceName(resourceName)).normalize().getPath());
        if (is == null) {
            ClassLoader classLoader = ClasspathResolver.class.getClassLoader();
            is = classLoader.getResourceAsStream(normalizeResourceName);
        }
        if (is != null) {
            return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        }
        return null;
    }

    private String concatResourceRootAndResourceName(String resourceName) {
        if (this.resourceRoot == null || resourceName == null) {
            return resourceName;
        }
        if (resourceName.startsWith("/") && this.resourceRoot.endsWith("/")) {
            return this.resourceRoot.substring(0, this.resourceRoot.length() - 1) + resourceName;
        }
        if (resourceName.startsWith("/") && !this.resourceRoot.endsWith("/") || !resourceName.startsWith("/") && this.resourceRoot.endsWith("/")) {
            return this.resourceRoot + resourceName;
        }
        return this.resourceRoot + "/" + resourceName;
    }
}

