/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.HdrHistogram;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.zip.DataFormatException;
import javax.xml.bind.DatatypeConverter;
import org.graylog.shaded.opensearch2.org.HdrHistogram.EncodableHistogram;

public class HistogramLogReader {
    private final Scanner scanner;
    private double startTimeSec = 0.0;
    private boolean observedStartTime = false;
    private double baseTimeSec = 0.0;
    private boolean observedBaseTime = false;

    public HistogramLogReader(String inputFileName) throws FileNotFoundException {
        this.scanner = new Scanner(new File(inputFileName));
        this.initScanner();
    }

    public HistogramLogReader(InputStream inputStream) {
        this.scanner = new Scanner(inputStream);
        this.initScanner();
    }

    public HistogramLogReader(File inputFile) throws FileNotFoundException {
        this.scanner = new Scanner(inputFile);
        this.initScanner();
    }

    private void initScanner() {
        this.scanner.useLocale(Locale.US);
        this.scanner.useDelimiter("[, \\r\\n]");
    }

    public double getStartTimeSec() {
        return this.startTimeSec;
    }

    public EncodableHistogram nextIntervalHistogram(double startTimeSec, double endTimeSec) {
        return this.nextIntervalHistogram(startTimeSec, endTimeSec, false);
    }

    public EncodableHistogram nextAbsoluteIntervalHistogram(double absoluteStartTimeSec, double absoluteEndTimeSec) {
        return this.nextIntervalHistogram(absoluteStartTimeSec, absoluteEndTimeSec, true);
    }

    public EncodableHistogram nextIntervalHistogram() {
        return this.nextIntervalHistogram(0.0, 9.223372036854776E18, true);
    }

    private EncodableHistogram nextIntervalHistogram(double rangeStartTimeSec, double rangeEndTimeSec, boolean absolute) {
        while (this.scanner.hasNextLine()) {
            try {
                double startTimeStampToCheckRangeOn;
                if (this.scanner.hasNext("\\#.*")) {
                    if (this.scanner.hasNext("#\\[StartTime:")) {
                        this.scanner.next("#\\[StartTime:");
                        if (this.scanner.hasNextDouble()) {
                            this.startTimeSec = this.scanner.nextDouble();
                            this.observedStartTime = true;
                        }
                    } else if (this.scanner.hasNext("#\\[BaseTime:")) {
                        this.scanner.next("#\\[BaseTime:");
                        if (this.scanner.hasNextDouble()) {
                            this.baseTimeSec = this.scanner.nextDouble();
                            this.observedBaseTime = true;
                        }
                    }
                    this.scanner.nextLine();
                    continue;
                }
                if (this.scanner.hasNext("\"StartTimestamp\".*")) {
                    this.scanner.nextLine();
                    continue;
                }
                String tagString = null;
                if (this.scanner.hasNext("Tag\\=.*")) {
                    tagString = this.scanner.next("Tag\\=.*").substring(4);
                }
                double logTimeStampInSec = this.scanner.nextDouble();
                if (!this.observedStartTime) {
                    this.startTimeSec = logTimeStampInSec;
                    this.observedStartTime = true;
                }
                if (!this.observedBaseTime) {
                    this.baseTimeSec = logTimeStampInSec < this.startTimeSec - 3.1536E7 ? this.startTimeSec : 0.0;
                    this.observedBaseTime = true;
                }
                double absoluteStartTimeStampSec = logTimeStampInSec + this.baseTimeSec;
                double offsetStartTimeStampSec = absoluteStartTimeStampSec - this.startTimeSec;
                double intervalLengthSec = this.scanner.nextDouble();
                double absoluteEndTimeStampSec = absoluteStartTimeStampSec + intervalLengthSec;
                double d = startTimeStampToCheckRangeOn = absolute ? absoluteStartTimeStampSec : offsetStartTimeStampSec;
                if (startTimeStampToCheckRangeOn < rangeStartTimeSec) {
                    this.scanner.nextLine();
                    continue;
                }
                if (startTimeStampToCheckRangeOn > rangeEndTimeSec) {
                    return null;
                }
                this.scanner.nextDouble();
                String compressedPayloadString = this.scanner.next();
                ByteBuffer buffer = ByteBuffer.wrap(DatatypeConverter.parseBase64Binary((String)compressedPayloadString));
                EncodableHistogram histogram = EncodableHistogram.decodeFromCompressedByteBuffer(buffer, 0L);
                histogram.setStartTimeStamp((long)(absoluteStartTimeStampSec * 1000.0));
                histogram.setEndTimeStamp((long)(absoluteEndTimeStampSec * 1000.0));
                histogram.setTag(tagString);
                this.scanner.nextLine();
                return histogram;
            }
            catch (NoSuchElementException ex) {
                return null;
            }
            catch (DataFormatException ex) {
                return null;
            }
        }
        return null;
    }
}

