/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.el;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.CharArraySet;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.StopFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.WordlistLoader;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.el.GreekLowerCaseFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.el.GreekStemFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.standard.StandardTokenizer;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.IOUtils;

public final class GreekAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";

    public static final CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_SET;
    }

    public GreekAnalyzer() {
        this(DefaultSetHolder.DEFAULT_SET);
    }

    public GreekAnalyzer(CharArraySet stopwords) {
        super(stopwords);
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new GreekLowerCaseFilter(source);
        result = new StopFilter(result, this.stopwords);
        result = new GreekStemFilter(result);
        return new Analyzer.TokenStreamComponents(source, (TokenStream)result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new GreekLowerCaseFilter(in);
    }

    private static class DefaultSetHolder {
        private static final CharArraySet DEFAULT_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_SET = WordlistLoader.getWordSet(IOUtils.requireResourceNonNull(GreekAnalyzer.class.getResourceAsStream(GreekAnalyzer.DEFAULT_STOPWORD_FILE), GreekAnalyzer.DEFAULT_STOPWORD_FILE), "#");
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

