/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.en;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.CharArraySet;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenFilterFactory;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ResourceLoader;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ResourceLoaderAware;

public abstract class AbstractWordsFileFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String FORMAT_WORDSET = "wordset";
    public static final String FORMAT_SNOWBALL = "snowball";
    private CharArraySet words;
    private final String wordFiles;
    private final String format;
    private final boolean ignoreCase;

    protected AbstractWordsFileFilterFactory() {
        throw AbstractWordsFileFilterFactory.defaultCtorException();
    }

    public AbstractWordsFileFilterFactory(Map<String, String> args) {
        super(args);
        this.wordFiles = this.get(args, "words");
        this.format = this.get(args, "format", null == this.wordFiles ? null : FORMAT_WORDSET);
        this.ignoreCase = this.getBoolean(args, "ignoreCase", false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void inform(ResourceLoader loader) throws IOException {
        if (this.wordFiles != null) {
            if (FORMAT_WORDSET.equalsIgnoreCase(this.format)) {
                this.words = this.getWordSet(loader, this.wordFiles, this.ignoreCase);
                return;
            } else {
                if (!FORMAT_SNOWBALL.equalsIgnoreCase(this.format)) throw new IllegalArgumentException("Unknown 'format' specified for 'words' file: " + this.format);
                this.words = this.getSnowballWordSet(loader, this.wordFiles, this.ignoreCase);
            }
            return;
        } else {
            if (null != this.format) {
                throw new IllegalArgumentException("'format' can not be specified w/o an explicit 'words' file: " + this.format);
            }
            this.words = this.createDefaultWords();
        }
    }

    protected abstract CharArraySet createDefaultWords();

    public CharArraySet getWords() {
        return this.words;
    }

    public String getWordFiles() {
        return this.wordFiles;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }
}

