/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.miscellaneous;

import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenFilterFactory;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.miscellaneous.ConcatenateGraphFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Version;

public class ConcatenateGraphFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "concatenateGraph";
    private Character tokenSeparator;
    private boolean preservePositionIncrements;
    private int maxGraphExpansions;

    public ConcatenateGraphFilterFactory(Map<String, String> args) {
        super(args);
        boolean preserveSep;
        Version luceneMatchVersion = this.getLuceneMatchVersion();
        Version LUCENE_8_4_0 = Version.LUCENE_8_4_0;
        this.tokenSeparator = luceneMatchVersion.onOrAfter(LUCENE_8_4_0) ? this.getCharacter(args, "tokenSeparator", ConcatenateGraphFilter.DEFAULT_TOKEN_SEPARATOR) : ((preserveSep = this.getBoolean(args, "preserveSep", true)) ? ConcatenateGraphFilter.DEFAULT_TOKEN_SEPARATOR : null);
        this.preservePositionIncrements = this.getBoolean(args, "preservePositionIncrements", true);
        this.maxGraphExpansions = this.getInt(args, "maxGraphExpansions", 10000);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public ConcatenateGraphFilterFactory() {
        throw ConcatenateGraphFilterFactory.defaultCtorException();
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new ConcatenateGraphFilter(input, this.tokenSeparator, this.preservePositionIncrements, this.maxGraphExpansions);
    }

    protected Character getCharacter(Map<String, String> args, String name, Character defaultVal) {
        String s = args.remove(name);
        if (s == null) {
            return defaultVal;
        }
        if (s.length() == 0) {
            return null;
        }
        if (s.length() != 1) {
            throw new IllegalArgumentException(name + " should be a char. \"" + s + "\" is invalid");
        }
        return Character.valueOf(s.charAt(0));
    }
}

