/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.path;

import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Tokenizer;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenizerFactory;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.path.PathHierarchyTokenizer;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.path.ReversePathHierarchyTokenizer;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.AttributeFactory;

public class PathHierarchyTokenizerFactory
extends TokenizerFactory {
    public static final String NAME = "pathHierarchy";
    private final char delimiter;
    private final char replacement;
    private final boolean reverse;
    private final int skip;

    public PathHierarchyTokenizerFactory(Map<String, String> args) {
        super(args);
        this.delimiter = this.getChar(args, "delimiter", '/');
        this.replacement = this.getChar(args, "replace", this.delimiter);
        this.reverse = this.getBoolean(args, "reverse", false);
        this.skip = this.getInt(args, "skip", 0);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public PathHierarchyTokenizerFactory() {
        throw PathHierarchyTokenizerFactory.defaultCtorException();
    }

    @Override
    public Tokenizer create(AttributeFactory factory) {
        if (this.reverse) {
            return new ReversePathHierarchyTokenizer(factory, this.delimiter, this.replacement, this.skip);
        }
        return new PathHierarchyTokenizer(factory, this.delimiter, this.replacement, this.skip);
    }
}

