/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.sinks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.AttributeSource;

public final class TeeSinkTokenFilter
extends TokenFilter {
    private final States cachedStates = new States();

    public TeeSinkTokenFilter(TokenStream input) {
        super(input);
    }

    public TokenStream newSinkTokenStream() {
        return new SinkTokenStream(this.cloneAttributes(), this.cachedStates);
    }

    public void consumeAllTokens() throws IOException {
        while (this.incrementToken()) {
        }
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            this.cachedStates.add(this.captureState());
            return true;
        }
        return false;
    }

    @Override
    public final void end() throws IOException {
        super.end();
        this.cachedStates.setFinalState(this.captureState());
    }

    @Override
    public void reset() throws IOException {
        this.cachedStates.reset();
        super.reset();
    }

    private static final class States {
        private final List<AttributeSource.State> states = new ArrayList<AttributeSource.State>();
        private AttributeSource.State finalState;

        void setFinalState(AttributeSource.State finalState) {
            this.finalState = finalState;
        }

        AttributeSource.State getFinalState() {
            return this.finalState;
        }

        void add(AttributeSource.State state) {
            this.states.add(state);
        }

        Iterator<AttributeSource.State> getStates() {
            return this.states.iterator();
        }

        void reset() {
            this.finalState = null;
            this.states.clear();
        }
    }

    public static final class SinkTokenStream
    extends TokenStream {
        private final States cachedStates;
        private Iterator<AttributeSource.State> it = null;

        private SinkTokenStream(AttributeSource source, States cachedStates) {
            super(source);
            this.cachedStates = cachedStates;
        }

        @Override
        public final boolean incrementToken() {
            if (!this.it.hasNext()) {
                return false;
            }
            AttributeSource.State state = this.it.next();
            this.restoreState(state);
            return true;
        }

        @Override
        public void end() throws IOException {
            AttributeSource.State finalState = this.cachedStates.getFinalState();
            if (finalState != null) {
                this.restoreState(finalState);
            }
        }

        @Override
        public final void reset() {
            this.it = this.cachedStates.getStates();
        }
    }
}

