/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.codecs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Impact;

public final class CompetitiveImpactAccumulator {
    private final int[] maxFreqs = new int[256];
    private final TreeSet<Impact> otherFreqNormPairs;

    public CompetitiveImpactAccumulator() {
        Comparator<Impact> comparator = new Comparator<Impact>(){

            @Override
            public int compare(Impact o1, Impact o2) {
                int cmp = Integer.compare(o1.freq, o2.freq);
                if (cmp == 0) {
                    cmp = Long.compareUnsigned(o2.norm, o1.norm);
                }
                return cmp;
            }
        };
        this.otherFreqNormPairs = new TreeSet<Impact>(comparator);
    }

    public void clear() {
        Arrays.fill(this.maxFreqs, 0);
        this.otherFreqNormPairs.clear();
        assert (this.assertConsistent());
    }

    public void add(int freq, long norm) {
        if (norm >= -128L && norm <= 127L) {
            int index = Byte.toUnsignedInt((byte)norm);
            this.maxFreqs[index] = Math.max(this.maxFreqs[index], freq);
        } else {
            this.add(new Impact(freq, norm), this.otherFreqNormPairs);
        }
        assert (this.assertConsistent());
    }

    public void addAll(CompetitiveImpactAccumulator acc) {
        int[] maxFreqs = this.maxFreqs;
        int[] otherMaxFreqs = acc.maxFreqs;
        for (int i = 0; i < maxFreqs.length; ++i) {
            maxFreqs[i] = Math.max(maxFreqs[i], otherMaxFreqs[i]);
        }
        for (Impact entry : acc.otherFreqNormPairs) {
            this.add(entry, this.otherFreqNormPairs);
        }
        assert (this.assertConsistent());
    }

    public Collection<Impact> getCompetitiveFreqNormPairs() {
        ArrayList<Impact> impacts = new ArrayList<Impact>();
        int maxFreqForLowerNorms = 0;
        for (int i = 0; i < this.maxFreqs.length; ++i) {
            int maxFreq = this.maxFreqs[i];
            if (maxFreq <= maxFreqForLowerNorms) continue;
            impacts.add(new Impact(maxFreq, (byte)i));
            maxFreqForLowerNorms = maxFreq;
        }
        if (this.otherFreqNormPairs.isEmpty()) {
            return impacts;
        }
        TreeSet<Impact> freqNormPairs = new TreeSet<Impact>((SortedSet<Impact>)this.otherFreqNormPairs);
        for (Impact impact : impacts) {
            this.add(impact, freqNormPairs);
        }
        return Collections.unmodifiableSet(freqNormPairs);
    }

    private void add(Impact newEntry, TreeSet<Impact> freqNormPairs) {
        Impact next = freqNormPairs.ceiling(newEntry);
        if (next == null) {
            freqNormPairs.add(newEntry);
        } else {
            if (Long.compareUnsigned(next.norm, newEntry.norm) <= 0) {
                return;
            }
            freqNormPairs.add(newEntry);
        }
        Iterator<Impact> it = freqNormPairs.headSet(newEntry, false).descendingIterator();
        while (it.hasNext()) {
            Impact entry = it.next();
            if (Long.compareUnsigned(entry.norm, newEntry.norm) < 0) break;
            it.remove();
        }
    }

    public String toString() {
        return new ArrayList<Impact>(this.getCompetitiveFreqNormPairs()).toString();
    }

    private boolean assertConsistent() {
        for (int freq : this.maxFreqs) {
            assert (freq >= 0);
        }
        int previousFreq = 0;
        long previousNorm = 0L;
        for (Impact impact : this.otherFreqNormPairs) {
            assert (impact.norm < -128L || impact.norm > 127L);
            assert (previousFreq < impact.freq);
            assert (Long.compareUnsigned(previousNorm, impact.norm) < 0);
            previousFreq = impact.freq;
            previousNorm = impact.norm;
        }
        return true;
    }
}

