/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.document;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.ShapeField;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.Component2D;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.GeoEncodingUtils;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.LatLonGeometry;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.Line;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.Point;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreScorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreWeight;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.QueryVisitor;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TwoPhaseIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Weight;

class LatLonDocValuesQuery
extends Query {
    private final String field;
    private final LatLonGeometry[] geometries;
    private final ShapeField.QueryRelation queryRelation;
    private final Component2D component2D;

    LatLonDocValuesQuery(String field, ShapeField.QueryRelation queryRelation, LatLonGeometry ... geometries) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (queryRelation == null) {
            throw new IllegalArgumentException("queryRelation must not be null");
        }
        if (queryRelation == ShapeField.QueryRelation.WITHIN) {
            for (LatLonGeometry geometry : geometries) {
                if (!(geometry instanceof Line)) continue;
                throw new IllegalArgumentException("LatLonDocValuesPointQuery does not support " + ShapeField.QueryRelation.WITHIN + " queries with line geometries");
            }
        }
        if (queryRelation == ShapeField.QueryRelation.CONTAINS) {
            for (LatLonGeometry geometry : geometries) {
                if (geometry instanceof Point) continue;
                throw new IllegalArgumentException("LatLonDocValuesPointQuery does not support " + ShapeField.QueryRelation.CONTAINS + " queries with non-points geometries");
            }
        }
        this.field = field;
        this.geometries = geometries;
        this.queryRelation = queryRelation;
        this.component2D = LatLonGeometry.create(geometries);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append((Object)this.queryRelation).append(':');
        sb.append("geometries(").append(Arrays.toString(this.geometries));
        return sb.append(")").toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        LatLonDocValuesQuery other = (LatLonDocValuesQuery)obj;
        return this.field.equals(other.field) && this.queryRelation == other.queryRelation && Arrays.equals(this.geometries, other.geometries);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.field.hashCode();
        h = 31 * h + this.queryRelation.hashCode();
        h = 31 * h + Arrays.hashCode(this.geometries);
        return h;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, final float boost) throws IOException {
        final GeoEncodingUtils.Component2DPredicate component2DPredicate = this.queryRelation == ShapeField.QueryRelation.CONTAINS ? null : GeoEncodingUtils.createComponentPredicate(this.component2D);
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                TwoPhaseIterator iterator;
                SortedNumericDocValues values = context.reader().getSortedNumericDocValues(LatLonDocValuesQuery.this.field);
                if (values == null) {
                    return null;
                }
                switch (LatLonDocValuesQuery.this.queryRelation) {
                    case INTERSECTS: {
                        iterator = LatLonDocValuesQuery.this.intersects(values, component2DPredicate);
                        break;
                    }
                    case WITHIN: {
                        iterator = LatLonDocValuesQuery.this.within(values, component2DPredicate);
                        break;
                    }
                    case DISJOINT: {
                        iterator = LatLonDocValuesQuery.this.disjoint(values, component2DPredicate);
                        break;
                    }
                    case CONTAINS: {
                        iterator = LatLonDocValuesQuery.this.contains(values, LatLonDocValuesQuery.this.geometries);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid query relationship:[" + LatLonDocValuesQuery.this.queryRelation + "]");
                    }
                }
                return new ConstantScoreScorer((Weight)this, boost, scoreMode, iterator);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, LatLonDocValuesQuery.this.field);
            }
        };
    }

    private TwoPhaseIterator intersects(final SortedNumericDocValues values, final GeoEncodingUtils.Component2DPredicate component2DPredicate) {
        return new TwoPhaseIterator(values){

            @Override
            public boolean matches() throws IOException {
                int count = values.docValueCount();
                for (int i = 0; i < count; ++i) {
                    int lon;
                    long value = values.nextValue();
                    int lat = (int)(value >>> 32);
                    if (!component2DPredicate.test(lat, lon = (int)(value & 0xFFFFFFFFFFFFFFFFL))) continue;
                    return true;
                }
                return false;
            }

            @Override
            public float matchCost() {
                return 1000.0f;
            }
        };
    }

    private TwoPhaseIterator within(final SortedNumericDocValues values, final GeoEncodingUtils.Component2DPredicate component2DPredicate) {
        return new TwoPhaseIterator(values){

            @Override
            public boolean matches() throws IOException {
                int count = values.docValueCount();
                for (int i = 0; i < count; ++i) {
                    int lon;
                    long value = values.nextValue();
                    int lat = (int)(value >>> 32);
                    if (component2DPredicate.test(lat, lon = (int)(value & 0xFFFFFFFFFFFFFFFFL))) continue;
                    return false;
                }
                return true;
            }

            @Override
            public float matchCost() {
                return 1000.0f;
            }
        };
    }

    private TwoPhaseIterator disjoint(final SortedNumericDocValues values, final GeoEncodingUtils.Component2DPredicate component2DPredicate) {
        return new TwoPhaseIterator(values){

            @Override
            public boolean matches() throws IOException {
                int count = values.docValueCount();
                for (int i = 0; i < count; ++i) {
                    int lon;
                    long value = values.nextValue();
                    int lat = (int)(value >>> 32);
                    if (!component2DPredicate.test(lat, lon = (int)(value & 0xFFFFFFFFFFFFFFFFL))) continue;
                    return false;
                }
                return true;
            }

            @Override
            public float matchCost() {
                return 1000.0f;
            }
        };
    }

    private TwoPhaseIterator contains(final SortedNumericDocValues values, LatLonGeometry[] geometries) {
        final ArrayList<Component2D> component2Ds = new ArrayList<Component2D>(geometries.length);
        for (int i = 0; i < geometries.length; ++i) {
            component2Ds.add(LatLonGeometry.create(geometries[i]));
        }
        return new TwoPhaseIterator(values){

            @Override
            public boolean matches() throws IOException {
                Component2D.WithinRelation answer = Component2D.WithinRelation.DISJOINT;
                int count = values.docValueCount();
                for (int i = 0; i < count; ++i) {
                    long value = values.nextValue();
                    double lat = GeoEncodingUtils.decodeLatitude((int)(value >>> 32));
                    double lon = GeoEncodingUtils.decodeLongitude((int)(value & 0xFFFFFFFFFFFFFFFFL));
                    for (Component2D component2D : component2Ds) {
                        Component2D.WithinRelation relation = component2D.withinPoint(lon, lat);
                        if (relation == Component2D.WithinRelation.NOTWITHIN) {
                            return false;
                        }
                        if (relation == Component2D.WithinRelation.DISJOINT) continue;
                        answer = relation;
                    }
                }
                return answer == Component2D.WithinRelation.CANDIDATE;
            }

            @Override
            public float matchCost() {
                return 1000.0f;
            }
        };
    }
}

