/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.document;

import org.graylog.shaded.opensearch2.org.apache.lucene.document.XYPointDistanceComparator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.FieldComparator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.SortField;

final class XYPointSortField
extends SortField {
    final float x;
    final float y;

    XYPointSortField(String field, float x, float y) {
        super(field, SortField.Type.CUSTOM);
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        this.x = x;
        this.y = y;
        this.setMissingValue(Double.POSITIVE_INFINITY);
    }

    @Override
    public FieldComparator<?> getComparator(int numHits, boolean enableSkipping) {
        return new XYPointDistanceComparator(this.getField(), this.x, this.y, numHits);
    }

    @Override
    public Double getMissingValue() {
        return (Double)super.getMissingValue();
    }

    @Override
    public void setMissingValue(Object missingValue) {
        if (!Double.valueOf(Double.POSITIVE_INFINITY).equals(missingValue)) {
            throw new IllegalArgumentException("Missing value can only be Double.POSITIVE_INFINITY (missing values last), but got " + missingValue);
        }
        this.missingValue = missingValue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Float.floatToIntBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Float.floatToIntBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XYPointSortField other = (XYPointSortField)obj;
        return this.x == other.x && this.y == other.y;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<distance:");
        builder.append('\"');
        builder.append(this.getField());
        builder.append('\"');
        builder.append(" x=");
        builder.append(this.x);
        builder.append(" y=");
        builder.append(this.y);
        if (Double.POSITIVE_INFINITY != this.getMissingValue()) {
            builder.append(" missingValue=").append(this.getMissingValue());
        }
        builder.append('>');
        return builder.toString();
    }
}

