/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.geo;

import org.graylog.shaded.opensearch2.org.apache.lucene.geo.Circle2D;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.Component2D;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.GeoUtils;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.LatLonGeometry;

public final class Circle
extends LatLonGeometry {
    private final double lat;
    private final double lon;
    private final double radiusMeters;

    public Circle(double lat, double lon, double radiusMeters) {
        GeoUtils.checkLatitude(lat);
        GeoUtils.checkLongitude(lon);
        if (!Double.isFinite(radiusMeters) || radiusMeters < 0.0) {
            throw new IllegalArgumentException("radiusMeters: '" + radiusMeters + "' is invalid");
        }
        this.lat = lat;
        this.lon = lon;
        this.radiusMeters = radiusMeters;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public double getRadius() {
        return this.radiusMeters;
    }

    @Override
    protected Component2D toComponent2D() {
        return Circle2D.create(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Circle)) {
            return false;
        }
        Circle circle = (Circle)o;
        return this.lat == circle.lat && this.lon == circle.lon && this.radiusMeters == circle.radiusMeters;
    }

    public int hashCode() {
        int result = Double.hashCode(this.lat);
        result = 31 * result + Double.hashCode(this.lon);
        result = 31 * result + Double.hashCode(this.radiusMeters);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CIRCLE(");
        sb.append("[" + this.lat + "," + this.lon + "]");
        sb.append(" radius = " + this.radiusMeters + " meters");
        sb.append(')');
        return sb.toString();
    }
}

