/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.geo;

import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.Component2D;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.ComponentTree;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.GeoEncodingUtils;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.GeoUtils;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.Rectangle;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.XYRectangle;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.PointValues;

final class Rectangle2D
implements Component2D {
    private final double minX;
    private final double maxX;
    private final double minY;
    private final double maxY;
    private static double MIN_LON_INCL_QUANTIZE = GeoEncodingUtils.decodeLongitude(GeoEncodingUtils.MIN_LON_ENCODED);
    private static double MAX_LON_INCL_QUANTIZE = GeoEncodingUtils.decodeLongitude(GeoEncodingUtils.MAX_LON_ENCODED);

    private Rectangle2D(double minX, double maxX, double minY, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    @Override
    public boolean contains(double x, double y) {
        return Component2D.containsPoint(x, y, this.minX, this.maxX, this.minY, this.maxY);
    }

    @Override
    public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (Component2D.within(minX, maxX, minY, maxY, this.minX, this.maxX, this.minY, this.maxY)) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    @Override
    public boolean intersectsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return false;
        }
        return this.contains(aX, aY) || this.contains(bX, bY) || this.edgesIntersect(aX, aY, bX, bY);
    }

    @Override
    public boolean intersectsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return false;
        }
        return this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY) || Component2D.pointInTriangle(minX, maxX, minY, maxY, this.minX, this.minY, aX, aY, bX, bY, cX, cY) || this.edgesIntersect(aX, aY, bX, bY) || this.edgesIntersect(bX, bY, cX, cY) || this.edgesIntersect(cX, cY, aX, aY);
    }

    @Override
    public boolean containsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        return Component2D.within(minX, maxX, minY, maxY, this.minX, this.maxX, this.minY, this.maxY);
    }

    @Override
    public boolean containsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        return Component2D.within(minX, maxX, minY, maxY, this.minX, this.maxX, this.minY, this.maxY);
    }

    @Override
    public Component2D.WithinRelation withinPoint(double x, double y) {
        return this.contains(x, y) ? Component2D.WithinRelation.NOTWITHIN : Component2D.WithinRelation.DISJOINT;
    }

    @Override
    public Component2D.WithinRelation withinLine(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY) {
        if (ab && !Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY) && this.edgesIntersect(aX, aY, bX, bY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        return Component2D.WithinRelation.DISJOINT;
    }

    @Override
    public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        Component2D.WithinRelation relation = Component2D.WithinRelation.DISJOINT;
        if (this.edgesIntersect(aX, aY, bX, bY)) {
            if (ab) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.edgesIntersect(bX, bY, cX, cY)) {
            if (bc) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.edgesIntersect(cX, cY, aX, aY)) {
            if (ca) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (relation == Component2D.WithinRelation.CANDIDATE) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        if (Component2D.pointInTriangle(minX, maxX, minY, maxY, this.minX, this.minY, aX, aY, bX, bY, cX, cY)) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        return relation;
    }

    private boolean edgesIntersect(double aX, double aY, double bX, double bY) {
        if (Math.max(aX, bX) < this.minX || Math.min(aX, bX) > this.maxX || Math.min(aY, bY) > this.maxY || Math.max(aY, bY) < this.minY) {
            return false;
        }
        return GeoUtils.lineCrossesLineWithBoundary(aX, aY, bX, bY, this.minX, this.maxY, this.maxX, this.maxY) || GeoUtils.lineCrossesLineWithBoundary(aX, aY, bX, bY, this.maxX, this.maxY, this.maxX, this.minY) || GeoUtils.lineCrossesLineWithBoundary(aX, aY, bX, bY, this.maxX, this.minY, this.minX, this.minY) || GeoUtils.lineCrossesLineWithBoundary(aX, aY, bX, bY, this.minX, this.minY, this.minX, this.maxY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Rectangle2D)) {
            return false;
        }
        Rectangle2D that = (Rectangle2D)o;
        return this.minX == that.minX && this.maxX == that.maxX && this.minY == that.minY && this.maxY == that.maxY;
    }

    public int hashCode() {
        int result = Objects.hash(this.minX, this.maxX, this.minY, this.maxY);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XYRectangle(x=");
        sb.append(this.minX);
        sb.append(" TO ");
        sb.append(this.maxX);
        sb.append(" y=");
        sb.append(this.minY);
        sb.append(" TO ");
        sb.append(this.maxY);
        sb.append(")");
        return sb.toString();
    }

    static Component2D create(XYRectangle rectangle) {
        return new Rectangle2D(rectangle.minX, rectangle.maxX, rectangle.minY, rectangle.maxY);
    }

    static Component2D create(Rectangle rectangle) {
        boolean crossesDateline;
        double minLongitude = rectangle.minLon;
        boolean bl = crossesDateline = rectangle.minLon > rectangle.maxLon;
        if (minLongitude == 180.0 && crossesDateline) {
            minLongitude = -180.0;
            crossesDateline = false;
        }
        double qMinLat = GeoEncodingUtils.decodeLatitude(GeoEncodingUtils.encodeLatitudeCeil(rectangle.minLat));
        double qMaxLat = GeoEncodingUtils.decodeLatitude(GeoEncodingUtils.encodeLatitude(rectangle.maxLat));
        double qMinLon = GeoEncodingUtils.decodeLongitude(GeoEncodingUtils.encodeLongitudeCeil(minLongitude));
        double qMaxLon = GeoEncodingUtils.decodeLongitude(GeoEncodingUtils.encodeLongitude(rectangle.maxLon));
        if (crossesDateline) {
            Component2D[] components = new Component2D[]{new Rectangle2D(MIN_LON_INCL_QUANTIZE, qMaxLon, qMinLat, qMaxLat), new Rectangle2D(qMinLon, MAX_LON_INCL_QUANTIZE, qMinLat, qMaxLat)};
            return ComponentTree.create(components);
        }
        return new Rectangle2D(qMinLon, qMaxLon, qMinLat, qMaxLat);
    }
}

