/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.index;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.Codec;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.StoredFieldsWriter;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexableField;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentWriteState;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Sorter;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IOContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Accountable;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.IOUtils;

class StoredFieldsConsumer {
    final Codec codec;
    final Directory directory;
    final SegmentInfo info;
    StoredFieldsWriter writer;
    Accountable accountable = Accountable.NULL_ACCOUNTABLE;
    private int lastDoc;

    StoredFieldsConsumer(Codec codec, Directory directory, SegmentInfo info) {
        this.codec = codec;
        this.directory = directory;
        this.info = info;
        this.lastDoc = -1;
    }

    protected void initStoredFieldsWriter() throws IOException {
        if (this.writer == null) {
            this.writer = this.codec.storedFieldsFormat().fieldsWriter(this.directory, this.info, IOContext.DEFAULT);
            this.accountable = this.writer;
        }
    }

    void startDocument(int docID) throws IOException {
        assert (this.lastDoc < docID);
        this.initStoredFieldsWriter();
        while (++this.lastDoc < docID) {
            this.writer.startDocument();
            this.writer.finishDocument();
        }
        this.writer.startDocument();
    }

    void writeField(FieldInfo info, IndexableField field) throws IOException {
        this.writer.writeField(info, field);
    }

    void finishDocument() throws IOException {
        this.writer.finishDocument();
    }

    void finish(int maxDoc) throws IOException {
        while (this.lastDoc < maxDoc - 1) {
            this.startDocument(this.lastDoc);
            this.finishDocument();
            ++this.lastDoc;
        }
    }

    void flush(SegmentWriteState state, Sorter.DocMap sortMap) throws IOException {
        try {
            this.writer.finish(state.segmentInfo.maxDoc());
        }
        catch (Throwable throwable) {
            IOUtils.close(this.writer);
            throw throwable;
        }
        IOUtils.close(this.writer);
    }

    void abort() {
        IOUtils.closeWhileHandlingException(this.writer);
    }
}

