/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.index;

import org.graylog.shaded.opensearch2.org.apache.lucene.util.VectorUtil;

public enum VectorSimilarityFunction {
    EUCLIDEAN(true){

        @Override
        public float compare(float[] v1, float[] v2) {
            return VectorUtil.squareDistance(v1, v2);
        }

        @Override
        public float convertToScore(float similarity) {
            return 1.0f / (1.0f + similarity);
        }
    }
    ,
    DOT_PRODUCT{

        @Override
        public float compare(float[] v1, float[] v2) {
            return VectorUtil.dotProduct(v1, v2);
        }

        @Override
        public float convertToScore(float similarity) {
            return (1.0f + similarity) / 2.0f;
        }
    }
    ,
    COSINE{

        @Override
        public float compare(float[] v1, float[] v2) {
            return VectorUtil.cosine(v1, v2);
        }

        @Override
        public float convertToScore(float similarity) {
            return (1.0f + similarity) / 2.0f;
        }
    };

    public final boolean reversed;

    private VectorSimilarityFunction(boolean reversed) {
        this.reversed = reversed;
    }

    private VectorSimilarityFunction() {
        this.reversed = false;
    }

    public abstract float compare(float[] var1, float[] var2);

    public abstract float convertToScore(float var1);
}

