/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.index;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.KnnVectorsReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.KnnVectorsWriter;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocsWithFieldSet;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.RandomAccessVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.RandomAccessVectorValuesProducer;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Sorter;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Bits;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Counter;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.RamUsageEstimator;

class VectorValuesWriter {
    private final FieldInfo fieldInfo;
    private final Counter iwBytesUsed;
    private final List<float[]> vectors = new ArrayList<float[]>();
    private final DocsWithFieldSet docsWithField;
    private int lastDocID = -1;
    private long bytesUsed;

    VectorValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed) {
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        this.docsWithField = new DocsWithFieldSet();
        this.bytesUsed = this.docsWithField.ramBytesUsed();
        if (iwBytesUsed != null) {
            iwBytesUsed.addAndGet(this.bytesUsed);
        }
    }

    public void addValue(int docID, float[] vectorValue) {
        if (docID == this.lastDocID) {
            throw new IllegalArgumentException("VectorValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
        }
        if (vectorValue.length != this.fieldInfo.getVectorDimension()) {
            throw new IllegalArgumentException("Attempt to index a vector of dimension " + vectorValue.length + " but \"" + this.fieldInfo.name + "\" has dimension " + this.fieldInfo.getVectorDimension());
        }
        assert (docID > this.lastDocID);
        this.docsWithField.add(docID);
        this.vectors.add(ArrayUtil.copyOfSubArray(vectorValue, 0, vectorValue.length));
        this.updateBytesUsed();
        this.lastDocID = docID;
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.docsWithField.ramBytesUsed() + (long)(this.vectors.size() * (RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER)) + (long)(this.vectors.size() * this.vectors.get(0).length * 4);
        if (this.iwBytesUsed != null) {
            this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        }
        this.bytesUsed = newBytesUsed;
    }

    public void flush(final Sorter.DocMap sortMap, KnnVectorsWriter knnVectorsWriter) throws IOException {
        KnnVectorsReader knnVectorsReader = new KnnVectorsReader(){

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public void close() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void checkIntegrity() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public VectorValues getVectorValues(String field) throws IOException {
                BufferedVectorValues vectorValues = new BufferedVectorValues(VectorValuesWriter.this.docsWithField, VectorValuesWriter.this.vectors, VectorValuesWriter.this.fieldInfo.getVectorDimension());
                return sortMap != null ? new SortingVectorValues(vectorValues, sortMap) : vectorValues;
            }

            @Override
            public TopDocs search(String field, float[] target, int k, Bits acceptDocs, int visitedLimit) throws IOException {
                throw new UnsupportedOperationException();
            }
        };
        knnVectorsWriter.writeField(this.fieldInfo, knnVectorsReader);
    }

    private static class BufferedVectorValues
    extends VectorValues
    implements RandomAccessVectorValues,
    RandomAccessVectorValuesProducer {
        final DocsWithFieldSet docsWithField;
        final List<float[]> vectors;
        final int dimension;
        final ByteBuffer buffer;
        final BytesRef binaryValue;
        final ByteBuffer raBuffer;
        final BytesRef raBinaryValue;
        DocIdSetIterator docsWithFieldIter;
        int ord = -1;

        BufferedVectorValues(DocsWithFieldSet docsWithField, List<float[]> vectors, int dimension) {
            this.docsWithField = docsWithField;
            this.vectors = vectors;
            this.dimension = dimension;
            this.buffer = ByteBuffer.allocate(dimension * 4).order(ByteOrder.LITTLE_ENDIAN);
            this.binaryValue = new BytesRef(this.buffer.array());
            this.raBuffer = ByteBuffer.allocate(dimension * 4).order(ByteOrder.LITTLE_ENDIAN);
            this.raBinaryValue = new BytesRef(this.raBuffer.array());
            this.docsWithFieldIter = docsWithField.iterator();
        }

        @Override
        public RandomAccessVectorValues randomAccess() {
            return new BufferedVectorValues(this.docsWithField, this.vectors, this.dimension);
        }

        @Override
        public int dimension() {
            return this.dimension;
        }

        @Override
        public int size() {
            return this.vectors.size();
        }

        @Override
        public BytesRef binaryValue() {
            this.buffer.asFloatBuffer().put(this.vectorValue());
            return this.binaryValue;
        }

        @Override
        public BytesRef binaryValue(int targetOrd) {
            this.raBuffer.asFloatBuffer().put(this.vectors.get(targetOrd));
            return this.raBinaryValue;
        }

        @Override
        public float[] vectorValue() {
            return this.vectors.get(this.ord);
        }

        @Override
        public float[] vectorValue(int targetOrd) {
            return this.vectors.get(targetOrd);
        }

        @Override
        public int docID() {
            return this.docsWithFieldIter.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int docID = this.docsWithFieldIter.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                ++this.ord;
            }
            return docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            return this.docsWithFieldIter.cost();
        }
    }

    static class SortingVectorValues
    extends VectorValues
    implements RandomAccessVectorValuesProducer {
        private final VectorValues delegate;
        private final RandomAccessVectorValues randomAccess;
        private final int[] docIdOffsets;
        private final int[] ordMap;
        private int docId = -1;

        SortingVectorValues(VectorValues delegate, Sorter.DocMap sortMap) throws IOException {
            int docID;
            this.delegate = delegate;
            this.randomAccess = ((RandomAccessVectorValuesProducer)((Object)delegate)).randomAccess();
            this.docIdOffsets = new int[sortMap.size()];
            int offset = 1;
            while ((docID = delegate.nextDoc()) != Integer.MAX_VALUE) {
                int newDocID = sortMap.oldToNew(docID);
                this.docIdOffsets[newDocID] = offset++;
            }
            this.ordMap = new int[offset - 1];
            int ord = 0;
            for (int docIdOffset : this.docIdOffsets) {
                if (docIdOffset == 0) continue;
                this.ordMap[ord++] = docIdOffset - 1;
            }
            assert (ord == this.ordMap.length);
        }

        @Override
        public int docID() {
            return this.docId;
        }

        @Override
        public int nextDoc() throws IOException {
            while (this.docId < this.docIdOffsets.length - 1) {
                ++this.docId;
                if (this.docIdOffsets[this.docId] == 0) continue;
                return this.docId;
            }
            this.docId = Integer.MAX_VALUE;
            return this.docId;
        }

        @Override
        public BytesRef binaryValue() throws IOException {
            return this.randomAccess.binaryValue(this.docIdOffsets[this.docId] - 1);
        }

        @Override
        public float[] vectorValue() throws IOException {
            return this.randomAccess.vectorValue(this.docIdOffsets[this.docId] - 1);
        }

        @Override
        public int dimension() {
            return this.delegate.dimension();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public int advance(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            return this.size();
        }

        @Override
        public RandomAccessVectorValues randomAccess() {
            final RandomAccessVectorValues delegateRA = ((RandomAccessVectorValuesProducer)((Object)this.delegate)).randomAccess();
            return new RandomAccessVectorValues(){

                @Override
                public int size() {
                    return delegateRA.size();
                }

                @Override
                public int dimension() {
                    return delegateRA.dimension();
                }

                @Override
                public float[] vectorValue(int targetOrd) throws IOException {
                    return delegateRA.vectorValue(ordMap[targetOrd]);
                }

                @Override
                public BytesRef binaryValue(int targetOrd) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

