/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.CachingTokenFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Term;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.BlockIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.ContainedByIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.ContainingIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.DisjunctionIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.ExtendedIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.FilteredIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.FixedFieldIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.IntervalBuilder;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.IntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.MinimumShouldMatchIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.MultiTermIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.NoMatchIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.NonOverlappingIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.NotContainedByIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.NotContainingIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.OffsetIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.OrderedIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.OverlappingIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.PayloadFilteredTermIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.TermIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.UnorderedIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.FuzzyQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.PrefixQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.WildcardQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.CompiledAutomaton;

public final class Intervals {
    public static final int DEFAULT_MAX_EXPANSIONS = 128;

    private Intervals() {
    }

    public static IntervalsSource term(BytesRef term) {
        return new TermIntervalsSource(term);
    }

    public static IntervalsSource term(String term) {
        return new TermIntervalsSource(new BytesRef(term));
    }

    public static IntervalsSource term(String term, Predicate<BytesRef> payloadFilter) {
        return Intervals.term(new BytesRef(term), payloadFilter);
    }

    public static IntervalsSource term(BytesRef term, Predicate<BytesRef> payloadFilter) {
        return new PayloadFilteredTermIntervalsSource(term, payloadFilter);
    }

    public static IntervalsSource phrase(String ... terms) {
        if (terms.length == 1) {
            return Intervals.term(terms[0]);
        }
        IntervalsSource[] sources = new IntervalsSource[terms.length];
        int i = 0;
        for (String term : terms) {
            sources[i] = Intervals.term(term);
            ++i;
        }
        return Intervals.phrase(sources);
    }

    public static IntervalsSource phrase(IntervalsSource ... subSources) {
        return BlockIntervalsSource.build(Arrays.asList(subSources));
    }

    public static IntervalsSource or(IntervalsSource ... subSources) {
        return Intervals.or(true, Arrays.asList(subSources));
    }

    public static IntervalsSource or(boolean rewrite, IntervalsSource ... subSources) {
        return Intervals.or(rewrite, Arrays.asList(subSources));
    }

    public static IntervalsSource or(List<IntervalsSource> subSources) {
        return Intervals.or(true, subSources);
    }

    public static IntervalsSource or(boolean rewrite, List<IntervalsSource> subSources) {
        return DisjunctionIntervalsSource.create(subSources, rewrite);
    }

    public static IntervalsSource prefix(BytesRef prefix) {
        return Intervals.prefix(prefix, 128);
    }

    public static IntervalsSource prefix(BytesRef prefix, int maxExpansions) {
        CompiledAutomaton ca = new CompiledAutomaton(PrefixQuery.toAutomaton(prefix), null, true, 10000, true);
        return new MultiTermIntervalsSource(ca, maxExpansions, prefix.utf8ToString() + "*");
    }

    public static IntervalsSource wildcard(BytesRef wildcard) {
        return Intervals.wildcard(wildcard, 128);
    }

    public static IntervalsSource wildcard(BytesRef wildcard, int maxExpansions) {
        CompiledAutomaton ca = new CompiledAutomaton(WildcardQuery.toAutomaton(new Term("", wildcard)));
        return new MultiTermIntervalsSource(ca, maxExpansions, wildcard.utf8ToString());
    }

    public static IntervalsSource fuzzyTerm(String term, int maxEdits) {
        return Intervals.fuzzyTerm(term, maxEdits, 0, true, 128);
    }

    public static IntervalsSource fuzzyTerm(String term, int maxEdits, int prefixLength, boolean transpositions, int maxExpansions) {
        return Intervals.multiterm(FuzzyQuery.getFuzzyAutomaton(term, maxEdits, prefixLength, transpositions), maxExpansions, term + "~" + maxEdits);
    }

    public static IntervalsSource multiterm(CompiledAutomaton ca, String pattern) {
        return Intervals.multiterm(ca, 128, pattern);
    }

    public static IntervalsSource multiterm(CompiledAutomaton ca, int maxExpansions, String pattern) {
        return new MultiTermIntervalsSource(ca, maxExpansions, pattern);
    }

    public static IntervalsSource maxwidth(int width, IntervalsSource subSource) {
        return FilteredIntervalsSource.maxWidth(subSource, width);
    }

    public static IntervalsSource maxgaps(int gaps, IntervalsSource subSource) {
        return FilteredIntervalsSource.maxGaps(subSource, gaps);
    }

    public static IntervalsSource extend(IntervalsSource source, int before, int after) {
        return new ExtendedIntervalsSource(source, before, after);
    }

    public static IntervalsSource ordered(IntervalsSource ... subSources) {
        return OrderedIntervalsSource.build(Arrays.asList(subSources));
    }

    public static IntervalsSource unordered(IntervalsSource ... subSources) {
        return UnorderedIntervalsSource.build(Arrays.asList(subSources));
    }

    public static IntervalsSource unorderedNoOverlaps(IntervalsSource a, IntervalsSource b) {
        return Intervals.or(Intervals.ordered(a, b), Intervals.ordered(b, a));
    }

    public static IntervalsSource fixField(String field, IntervalsSource source) {
        return new FixedFieldIntervalsSource(field, source);
    }

    public static IntervalsSource nonOverlapping(IntervalsSource minuend, IntervalsSource subtrahend) {
        return new NonOverlappingIntervalsSource(minuend, subtrahend);
    }

    public static IntervalsSource overlapping(IntervalsSource source, IntervalsSource reference) {
        return new OverlappingIntervalsSource(source, reference);
    }

    public static IntervalsSource notWithin(IntervalsSource minuend, int positions, IntervalsSource subtrahend) {
        return new NonOverlappingIntervalsSource(minuend, Intervals.extend(subtrahend, positions, positions));
    }

    public static IntervalsSource within(IntervalsSource source, int positions, IntervalsSource reference) {
        return Intervals.containedBy(source, Intervals.extend(reference, positions, positions));
    }

    public static IntervalsSource notContaining(IntervalsSource minuend, IntervalsSource subtrahend) {
        return NotContainingIntervalsSource.build(minuend, subtrahend);
    }

    public static IntervalsSource containing(IntervalsSource big, IntervalsSource small) {
        return ContainingIntervalsSource.build(big, small);
    }

    public static IntervalsSource notContainedBy(IntervalsSource small, IntervalsSource big) {
        return NotContainedByIntervalsSource.build(small, big);
    }

    public static IntervalsSource containedBy(IntervalsSource small, IntervalsSource big) {
        return ContainedByIntervalsSource.build(small, big);
    }

    public static IntervalsSource atLeast(int minShouldMatch, IntervalsSource ... sources) {
        if (minShouldMatch == sources.length) {
            return Intervals.unordered(sources);
        }
        if (minShouldMatch > sources.length) {
            return new NoMatchIntervalsSource("Too few sources to match minimum of [" + minShouldMatch + "]: " + Arrays.toString(sources));
        }
        return new MinimumShouldMatchIntervalsSource(sources, minShouldMatch);
    }

    public static IntervalsSource before(IntervalsSource source, IntervalsSource reference) {
        return ContainedByIntervalsSource.build(source, Intervals.extend(new OffsetIntervalsSource(reference, true), Integer.MAX_VALUE, 0));
    }

    public static IntervalsSource after(IntervalsSource source, IntervalsSource reference) {
        return ContainedByIntervalsSource.build(source, Intervals.extend(new OffsetIntervalsSource(reference, false), 0, Integer.MAX_VALUE));
    }

    public static IntervalsSource analyzedText(String text, Analyzer analyzer, String field, int maxGaps, boolean ordered) throws IOException {
        try (TokenStream ts = analyzer.tokenStream(field, text);){
            IntervalsSource intervalsSource = Intervals.analyzedText(ts, maxGaps, ordered);
            return intervalsSource;
        }
    }

    public static IntervalsSource analyzedText(TokenStream tokenStream, int maxGaps, boolean ordered) throws IOException {
        CachingTokenFilter stream = tokenStream instanceof CachingTokenFilter ? (CachingTokenFilter)tokenStream : new CachingTokenFilter(tokenStream);
        return IntervalBuilder.analyzeText(stream, maxGaps, ordered);
    }
}

