/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.ConjunctionIntervalIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.Disjunctions;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.IntervalIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.IntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.MinimizingConjunctionIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.RepeatingIntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.PriorityQueue;

class UnorderedIntervalsSource
extends MinimizingConjunctionIntervalsSource {
    static IntervalsSource build(List<IntervalsSource> sources) {
        if (sources.size() == 1) {
            return sources.get(0);
        }
        List<IntervalsSource> rewritten = UnorderedIntervalsSource.deduplicate(UnorderedIntervalsSource.flatten(sources));
        if (rewritten.size() == 1) {
            return rewritten.get(0);
        }
        return new UnorderedIntervalsSource(rewritten);
    }

    private static List<IntervalsSource> deduplicate(List<IntervalsSource> sources) {
        LinkedHashMap<IntervalsSource, Integer> counts = new LinkedHashMap<IntervalsSource, Integer>();
        for (IntervalsSource source : sources) {
            counts.compute(source, (k, v) -> v == null ? 1 : v + 1);
        }
        ArrayList<IntervalsSource> deduplicated = new ArrayList<IntervalsSource>();
        for (IntervalsSource source : counts.keySet()) {
            deduplicated.add(RepeatingIntervalsSource.build(source, (Integer)counts.get(source)));
        }
        if (deduplicated.size() == 1 && deduplicated.get(0) instanceof RepeatingIntervalsSource) {
            ((RepeatingIntervalsSource)deduplicated.get(0)).setName("UNORDERED");
        }
        return deduplicated;
    }

    private static List<IntervalsSource> flatten(List<IntervalsSource> sources) {
        ArrayList<IntervalsSource> flattened = new ArrayList<IntervalsSource>();
        for (IntervalsSource s : sources) {
            if (s instanceof UnorderedIntervalsSource) {
                flattened.addAll(((UnorderedIntervalsSource)s).subSources);
                continue;
            }
            flattened.add(s);
        }
        return flattened;
    }

    private UnorderedIntervalsSource(List<IntervalsSource> sources) {
        super(sources);
    }

    @Override
    protected IntervalIterator combine(List<IntervalIterator> iterators, MinimizingConjunctionIntervalsSource.MatchCallback onMatch) {
        return new UnorderedIntervalIterator(iterators, onMatch);
    }

    @Override
    public int minExtent() {
        int minExtent = 0;
        for (IntervalsSource subSource : this.subSources) {
            minExtent += subSource.minExtent();
        }
        return minExtent;
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Disjunctions.pullUp(this.subSources, UnorderedIntervalsSource::new);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.subSources);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof UnorderedIntervalsSource)) {
            return false;
        }
        UnorderedIntervalsSource o = (UnorderedIntervalsSource)other;
        return Objects.equals(this.subSources, o.subSources);
    }

    @Override
    public String toString() {
        return "UNORDERED(" + this.subSources.stream().map(IntervalsSource::toString).collect(Collectors.joining(",")) + ")";
    }

    private static class UnorderedIntervalIterator
    extends ConjunctionIntervalIterator {
        private final PriorityQueue<IntervalIterator> queue;
        private final IntervalIterator[] subIterators;
        private final MinimizingConjunctionIntervalsSource.MatchCallback onMatch;
        int start = -1;
        int end = -1;
        int slop;
        int queueEnd;

        UnorderedIntervalIterator(List<IntervalIterator> subIterators, MinimizingConjunctionIntervalsSource.MatchCallback onMatch) {
            super(subIterators);
            this.queue = new PriorityQueue<IntervalIterator>(subIterators.size()){

                @Override
                protected boolean lessThan(IntervalIterator a, IntervalIterator b) {
                    return a.start() < b.start() || a.start() == b.start() && a.end() >= b.end();
                }
            };
            this.subIterators = new IntervalIterator[subIterators.size()];
            this.onMatch = onMatch;
            for (int i = 0; i < subIterators.size(); ++i) {
                this.subIterators[i] = subIterators.get(i);
            }
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        void updateRightExtreme(IntervalIterator it) {
            int itEnd = it.end();
            if (itEnd > this.queueEnd) {
                this.queueEnd = itEnd;
            }
        }

        @Override
        public int nextInterval() throws IOException {
            Object it;
            while (this.queue.size() == this.subIterators.length && this.queue.top().start() == this.start) {
                it = this.queue.pop();
                if (it == null || ((IntervalIterator)it).nextInterval() == Integer.MAX_VALUE) continue;
                this.queue.add((IntervalIterator)it);
                this.updateRightExtreme((IntervalIterator)it);
            }
            if (this.queue.size() < this.subIterators.length) {
                this.end = Integer.MAX_VALUE;
                this.start = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            do {
                this.start = this.queue.top().start();
                this.end = this.queueEnd;
                this.slop = this.width();
                for (IntervalIterator it2 : this.subIterators) {
                    this.slop -= it2.width();
                }
                this.onMatch.onMatch();
                if (this.queue.top().end() == this.end) {
                    return this.start;
                }
                it = this.queue.pop();
                if (it == null || ((IntervalIterator)it).nextInterval() == Integer.MAX_VALUE) continue;
                this.queue.add((IntervalIterator)it);
                this.updateRightExtreme((IntervalIterator)it);
            } while (this.queue.size() == this.subIterators.length && this.end == this.queueEnd);
            return this.start;
        }

        @Override
        public int gaps() {
            return this.slop;
        }

        @Override
        protected void reset() throws IOException {
            this.end = -1;
            this.start = -1;
            this.queueEnd = -1;
            this.queue.clear();
            for (IntervalIterator it : this.subIterators) {
                if (it.nextInterval() == Integer.MAX_VALUE) break;
                this.queue.add(it);
                this.updateRightExtreme(it);
            }
        }
    }
}

