/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.queries.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.spans.Spans;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConjunctionUtils;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TwoPhaseIterator;

abstract class ConjunctionSpans
extends Spans {
    final Spans[] subSpans;
    final DocIdSetIterator conjunction;
    boolean atFirstInCurrentDoc;
    boolean oneExhaustedInCurrentDoc;

    ConjunctionSpans(List<Spans> subSpans) {
        if (subSpans.size() < 2) {
            throw new IllegalArgumentException("Less than 2 subSpans.size():" + subSpans.size());
        }
        this.subSpans = subSpans.toArray(new Spans[subSpans.size()]);
        this.conjunction = ConjunctionSpans.intersectSpans(subSpans);
        this.atFirstInCurrentDoc = true;
    }

    @Override
    public int docID() {
        return this.conjunction.docID();
    }

    @Override
    public long cost() {
        return this.conjunction.cost();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.conjunction.nextDoc() == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.toMatchDoc();
    }

    @Override
    public int advance(int target) throws IOException {
        return this.conjunction.advance(target) == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.toMatchDoc();
    }

    int toMatchDoc() throws IOException {
        this.oneExhaustedInCurrentDoc = false;
        do {
            if (!this.twoPhaseCurrentDocMatches()) continue;
            return this.docID();
        } while (this.conjunction.nextDoc() != Integer.MAX_VALUE);
        return Integer.MAX_VALUE;
    }

    abstract boolean twoPhaseCurrentDocMatches() throws IOException;

    @Override
    public TwoPhaseIterator asTwoPhaseIterator() {
        float totalMatchCost = 0.0f;
        for (Spans spans : this.subSpans) {
            TwoPhaseIterator tpi = spans.asTwoPhaseIterator();
            if (tpi != null) {
                totalMatchCost += tpi.matchCost();
                continue;
            }
            totalMatchCost += spans.positionsCost();
        }
        final float matchCost = totalMatchCost;
        return new TwoPhaseIterator(this.conjunction){

            @Override
            public boolean matches() throws IOException {
                return ConjunctionSpans.this.twoPhaseCurrentDocMatches();
            }

            @Override
            public float matchCost() {
                return matchCost;
            }
        };
    }

    @Override
    public float positionsCost() {
        throw new UnsupportedOperationException();
    }

    public Spans[] getSubSpans() {
        return this.subSpans;
    }

    private static DocIdSetIterator intersectSpans(List<Spans> spanList) {
        if (spanList.size() < 2) {
            throw new IllegalArgumentException("Cannot make a ConjunctionDISI of less than 2 iterators");
        }
        ArrayList<DocIdSetIterator> allIterators = new ArrayList<DocIdSetIterator>();
        ArrayList<TwoPhaseIterator> twoPhaseIterators = new ArrayList<TwoPhaseIterator>();
        for (Spans spans : spanList) {
            ConjunctionSpans.addSpans(spans, allIterators, twoPhaseIterators);
        }
        return ConjunctionUtils.createConjunction(allIterators, twoPhaseIterators);
    }

    private static void addSpans(Spans spans, List<DocIdSetIterator> allIterators, List<TwoPhaseIterator> twoPhaseIterators) {
        TwoPhaseIterator twoPhaseIter = spans.asTwoPhaseIterator();
        if (twoPhaseIter != null) {
            ConjunctionUtils.addTwoPhaseIterator(twoPhaseIter, allIterators, twoPhaseIterators);
        } else {
            ConjunctionUtils.addIterator(spans, allIterators, twoPhaseIterators);
        }
    }
}

