/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.queryparser.xml.builders;

import java.util.ArrayList;
import org.graylog.shaded.opensearch2.org.apache.lucene.queryparser.xml.DOMUtils;
import org.graylog.shaded.opensearch2.org.apache.lucene.queryparser.xml.ParserException;
import org.graylog.shaded.opensearch2.org.apache.lucene.queryparser.xml.QueryBuilder;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.BoostQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DisjunctionMaxQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DisjunctionMaxQueryBuilder
implements QueryBuilder {
    private final QueryBuilder factory;

    public DisjunctionMaxQueryBuilder(QueryBuilder factory) {
        this.factory = factory;
    }

    @Override
    public Query getQuery(Element e) throws ParserException {
        float tieBreaker = DOMUtils.getAttribute(e, "tieBreaker", 0.0f);
        ArrayList<Query> disjuncts = new ArrayList<Query>();
        NodeList nl = e.getChildNodes();
        int nlLen = nl.getLength();
        for (int i = 0; i < nlLen; ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element queryElem = (Element)node;
            Query q = this.factory.getQuery(queryElem);
            disjuncts.add(q);
        }
        Query q = new DisjunctionMaxQuery(disjuncts, tieBreaker);
        float boost = DOMUtils.getAttribute(e, "boost", 1.0f);
        if (boost != 1.0f) {
            q = new BoostQuery(q, boost);
        }
        return q;
    }
}

