/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.search;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.search.QueryProfilerTimer;
import org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.search.QueryProfilerTimingType;

class QueryProfilerBreakdown {
    private final QueryProfilerTimer[] timers = new QueryProfilerTimer[QueryProfilerTimingType.values().length];

    public QueryProfilerBreakdown() {
        for (int i = 0; i < this.timers.length; ++i) {
            this.timers[i] = new QueryProfilerTimer();
        }
    }

    public QueryProfilerTimer getTimer(QueryProfilerTimingType type) {
        return this.timers[type.ordinal()];
    }

    public final Map<String, Long> toBreakdownMap() {
        HashMap<Object, Long> map = new HashMap<Object, Long>(this.timers.length * 2);
        for (QueryProfilerTimingType type : QueryProfilerTimingType.values()) {
            map.put(type.toString(), this.timers[type.ordinal()].getApproximateTiming());
            map.put(type.toString() + "_count", this.timers[type.ordinal()].getCount());
        }
        return Collections.unmodifiableMap(map);
    }

    public final long toTotalTime() {
        long total = 0L;
        for (QueryProfilerTimer timer : this.timers) {
            total += timer.getApproximateTiming();
        }
        return total;
    }
}

