/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorer;

final class DisjunctionScoreBlockBoundaryPropagator {
    private static final Comparator<Scorer> MAX_SCORE_COMPARATOR = Comparator.comparing(s -> {
        try {
            return Float.valueOf(s.getMaxScore(Integer.MAX_VALUE));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }).thenComparing(Comparator.comparing(s -> s.iterator().cost()));
    private final Scorer[] scorers;
    private final float[] maxScores;
    private int leadIndex = 0;

    DisjunctionScoreBlockBoundaryPropagator(Collection<Scorer> scorers) throws IOException {
        for (Scorer scorer : this.scorers = (Scorer[])scorers.toArray(Scorer[]::new)) {
            scorer.advanceShallow(0);
        }
        Arrays.sort(this.scorers, MAX_SCORE_COMPARATOR);
        this.maxScores = new float[this.scorers.length];
        for (int i = 0; i < this.scorers.length; ++i) {
            this.maxScores[i] = this.scorers[i].getMaxScore(Integer.MAX_VALUE);
        }
    }

    int advanceShallow(int target) throws IOException {
        Scorer scorer;
        int i;
        for (int i2 = 0; i2 < this.leadIndex; ++i2) {
            Scorer s = this.scorers[i2];
            if (s.docID() >= target) continue;
            s.advanceShallow(target);
        }
        Scorer leadScorer = this.scorers[this.leadIndex];
        int upTo = leadScorer.advanceShallow(Math.max(leadScorer.docID(), target));
        for (i = this.leadIndex + 1; i < this.scorers.length; ++i) {
            scorer = this.scorers[i];
            if (scorer.docID() > target) continue;
            upTo = Math.min(scorer.advanceShallow(target), upTo);
        }
        for (i = this.scorers.length - 1; i > this.leadIndex && (scorer = this.scorers[i]).docID() > target; --i) {
            upTo = Math.min(upTo, scorer.docID() - 1);
        }
        return upTo;
    }

    void setMinCompetitiveScore(float minScore) throws IOException {
        while (this.leadIndex < this.maxScores.length - 1 && minScore > this.maxScores[this.leadIndex]) {
            ++this.leadIndex;
        }
    }
}

