/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search;

import java.io.IOException;

public abstract class DoubleValues {
    public static final DoubleValues EMPTY = new DoubleValues(){

        @Override
        public double doubleValue() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            return false;
        }
    };

    public abstract double doubleValue() throws IOException;

    public abstract boolean advanceExact(int var1) throws IOException;

    public static DoubleValues withDefault(final DoubleValues in, final double missingValue) {
        return new DoubleValues(){
            boolean hasValue = false;

            @Override
            public double doubleValue() throws IOException {
                return this.hasValue ? in.doubleValue() : missingValue;
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                this.hasValue = in.advanceExact(doc);
                return true;
            }
        };
    }
}

