/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search;

import java.io.IOException;
import java.util.Collection;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.InPlaceMergeSorter;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.MathUtil;

final class MaxScoreSumPropagator {
    private final int numClauses;
    private final Scorer[] scorers;
    private final double[] sumOfOtherMaxScores;

    private static double[] computeSumOfComplement(float[] v) {
        double[] sum1 = new double[v.length];
        for (int i = 1; i < sum1.length; ++i) {
            sum1[i] = sum1[i - 1] + (double)v[i - 1];
        }
        double[] sum2 = new double[v.length];
        for (int i = sum2.length - 2; i >= 0; --i) {
            sum2[i] = sum2[i + 1] + (double)v[i + 1];
        }
        double[] result = new double[v.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = sum1[i] + sum2[i];
        }
        return result;
    }

    MaxScoreSumPropagator(Collection<? extends Scorer> scorerList) throws IOException {
        this.numClauses = scorerList.size();
        this.scorers = scorerList.toArray(new Scorer[this.numClauses]);
        final float[] maxScores = new float[this.numClauses];
        for (int i = 0; i < this.numClauses; ++i) {
            this.scorers[i].advanceShallow(0);
            maxScores[i] = this.scorers[i].getMaxScore(Integer.MAX_VALUE);
        }
        new InPlaceMergeSorter(){

            @Override
            protected void swap(int i, int j) {
                Scorer tmp = MaxScoreSumPropagator.this.scorers[i];
                MaxScoreSumPropagator.this.scorers[i] = MaxScoreSumPropagator.this.scorers[j];
                MaxScoreSumPropagator.this.scorers[j] = tmp;
                float tmpF = maxScores[i];
                maxScores[i] = maxScores[j];
                maxScores[j] = tmpF;
            }

            @Override
            protected int compare(int i, int j) {
                return Float.compare(maxScores[j], maxScores[i]);
            }
        }.sort(0, this.scorers.length);
        this.sumOfOtherMaxScores = MaxScoreSumPropagator.computeSumOfComplement(maxScores);
    }

    void advanceShallow(int target) throws IOException {
        for (Scorer s : this.scorers) {
            if (s.docID() >= target) continue;
            s.advanceShallow(target);
        }
    }

    float getMaxScore(int upTo) throws IOException {
        double maxScore = 0.0;
        for (Scorer s : this.scorers) {
            if (s.docID() > upTo) continue;
            maxScore += (double)s.getMaxScore(upTo);
        }
        return this.scoreSumUpperBound(maxScore);
    }

    void setMinCompetitiveScore(float minScore) throws IOException {
        double sumOfOtherMaxScores;
        float minCompetitiveScore;
        if (minScore == 0.0f) {
            return;
        }
        float minScoreDown = Math.nextDown(minScore);
        for (int i = 0; i < this.numClauses && !((minCompetitiveScore = this.getMinCompetitiveScore(minScoreDown, sumOfOtherMaxScores = this.sumOfOtherMaxScores[i])) <= 0.0f); ++i) {
            this.scorers[i].setMinCompetitiveScore(minCompetitiveScore);
        }
    }

    private float getMinCompetitiveScore(float minScoreSum, double sumOfOtherMaxScores) {
        assert (this.numClauses > 0);
        float minScore = (float)((double)minScoreSum - sumOfOtherMaxScores);
        int iter = 0;
        while (minScore > 0.0f && this.scoreSumUpperBound((double)minScore + sumOfOtherMaxScores) > minScoreSum) {
            minScore -= Math.ulp(minScoreSum);
            if (iter > 2) {
                throw new IllegalStateException("Could not compute a minimum score for minScore=" + minScore + ", minScoreSum=" + minScoreSum + ", sumOfOtherMaxScores=" + sumOfOtherMaxScores + ", numClauses=" + this.numClauses);
            }
            ++iter;
        }
        return Math.max(minScore, 0.0f);
    }

    private float scoreSumUpperBound(double sum) {
        if (this.numClauses <= 2) {
            return (float)sum;
        }
        double b = MathUtil.sumRelativeErrorBound(this.numClauses);
        return (float)((1.0 + 2.0 * b) * sum);
    }
}

