/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.SimpleCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.grouping.GroupReducer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.grouping.GroupSelector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.grouping.SearchGroup;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.grouping.SecondPassGroupingCollector;

public class DistinctValuesCollector<T, R>
extends SecondPassGroupingCollector<T> {
    public DistinctValuesCollector(GroupSelector<T> groupSelector, Collection<SearchGroup<T>> groups, GroupSelector<R> valueSelector) {
        super(groupSelector, groups, new DistinctValuesReducer(valueSelector));
    }

    public List<GroupCount<T, R>> getGroups() {
        ArrayList<GroupCount<T, R>> counts = new ArrayList<GroupCount<T, R>>();
        for (SearchGroup group : this.groups) {
            ValuesCollector vc = (ValuesCollector)this.groupReducer.getCollector(group.groupValue);
            counts.add(new GroupCount(group.groupValue, vc.values));
        }
        return counts;
    }

    public static class GroupCount<T, R> {
        public final T groupValue;
        public final Set<R> uniqueValues;

        public GroupCount(T groupValue, Set<R> values) {
            this.groupValue = groupValue;
            this.uniqueValues = values;
        }
    }

    private static class DistinctValuesReducer<T, R>
    extends GroupReducer<T, ValuesCollector<R>> {
        final GroupSelector<R> valueSelector;

        private DistinctValuesReducer(GroupSelector<R> valueSelector) {
            this.valueSelector = valueSelector;
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        protected ValuesCollector<R> newCollector() {
            return new ValuesCollector<R>(this.valueSelector);
        }
    }

    private static class ValuesCollector<R>
    extends SimpleCollector {
        final GroupSelector<R> valueSelector;
        final Set<R> values = new HashSet<R>();

        private ValuesCollector(GroupSelector<R> valueSelector) {
            this.valueSelector = valueSelector;
        }

        @Override
        public void collect(int doc) throws IOException {
            if (this.valueSelector.advanceTo(doc) == GroupSelector.State.ACCEPT) {
                R value = this.valueSelector.currentValue();
                if (!this.values.contains(value)) {
                    this.values.add(this.valueSelector.copyValue());
                }
            } else if (!this.values.contains(null)) {
                this.values.add(null);
            }
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.valueSelector.setNextReader(context);
        }

        @Override
        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE_NO_SCORES;
        }
    }
}

