/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search.suggest.analyzing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.FieldType;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.TextField;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.BinaryDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.MultiDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.PostingsEnum;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Terms;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.TermsEnum;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.BooleanClause;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.BooleanQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.FieldDoc;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopFieldDocs;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.suggest.Lookup;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.suggest.analyzing.AnalyzingInfixSuggester;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;

public class BlendedInfixSuggester
extends AnalyzingInfixSuggester {
    protected static double LINEAR_COEF = 0.1;
    private Double exponent = 2.0;
    public static int DEFAULT_NUM_FACTOR = 10;
    private final int numFactor;
    private final BlenderType blenderType;
    private static Comparator<Lookup.LookupResult> LOOKUP_COMP = new LookUpComparator();

    public BlendedInfixSuggester(Directory dir, Analyzer analyzer) throws IOException {
        super(dir, analyzer);
        this.blenderType = BlenderType.POSITION_LINEAR;
        this.numFactor = DEFAULT_NUM_FACTOR;
    }

    public BlendedInfixSuggester(Directory dir, Analyzer indexAnalyzer, Analyzer queryAnalyzer, int minPrefixChars, BlenderType blenderType, int numFactor, boolean commitOnBuild) throws IOException {
        super(dir, indexAnalyzer, queryAnalyzer, minPrefixChars, commitOnBuild);
        this.blenderType = blenderType;
        this.numFactor = numFactor;
    }

    public BlendedInfixSuggester(Directory dir, Analyzer indexAnalyzer, Analyzer queryAnalyzer, int minPrefixChars, BlenderType blenderType, int numFactor, Double exponent, boolean commitOnBuild, boolean allTermsRequired, boolean highlight) throws IOException {
        super(dir, indexAnalyzer, queryAnalyzer, minPrefixChars, commitOnBuild, allTermsRequired, highlight);
        this.blenderType = blenderType;
        this.numFactor = numFactor;
        if (exponent != null) {
            this.exponent = exponent;
        }
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, boolean onlyMorePopular, int num) throws IOException {
        return super.lookup(key, contexts, onlyMorePopular, num);
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, int num, boolean allTermsRequired, boolean doHighlight) throws IOException {
        return super.lookup(key, contexts, num, allTermsRequired, doHighlight);
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, Map<BytesRef, BooleanClause.Occur> contextInfo, int num, boolean allTermsRequired, boolean doHighlight) throws IOException {
        return super.lookup(key, contextInfo, num, allTermsRequired, doHighlight);
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, BooleanQuery contextQuery, int num, boolean allTermsRequired, boolean doHighlight) throws IOException {
        return super.lookup(key, contextQuery, num * this.numFactor, allTermsRequired, doHighlight);
    }

    @Override
    protected FieldType getTextFieldType() {
        FieldType ft = new FieldType(TextField.TYPE_NOT_STORED);
        ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        ft.setStoreTermVectors(true);
        ft.setStoreTermVectorPositions(true);
        ft.setOmitNorms(true);
        return ft;
    }

    @Override
    protected List<Lookup.LookupResult> createResults(IndexSearcher searcher, TopFieldDocs hits, int num, CharSequence key, boolean doHighlight, Set<String> matchedTokens, String prefixToken) throws IOException {
        TreeSet<Lookup.LookupResult> results = new TreeSet<Lookup.LookupResult>(LOOKUP_COMP);
        int actualNum = num / this.numFactor;
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            FieldDoc fd = (FieldDoc)hits.scoreDocs[i];
            BinaryDocValues textDV = MultiDocValues.getBinaryValues(searcher.getIndexReader(), "text");
            assert (textDV != null);
            textDV.advance(fd.doc);
            String text = textDV.binaryValue().utf8ToString();
            long weight = (Long)fd.fields[0];
            BinaryDocValues payloadsDV = MultiDocValues.getBinaryValues(searcher.getIndexReader(), "payloads");
            BytesRef payload = payloadsDV != null ? (payloadsDV.advance(fd.doc) == fd.doc ? BytesRef.deepCopyOf(payloadsDV.binaryValue()) : new BytesRef(BytesRef.EMPTY_BYTES)) : null;
            double coefficient = text.startsWith(key.toString()) ? 1.0 : this.createCoefficient(searcher, fd.doc, matchedTokens, prefixToken);
            if (weight == 0L) {
                weight = 1L;
            }
            if ((double)weight < 1.0 / LINEAR_COEF && (double)weight > -1.0 / LINEAR_COEF) {
                weight = (long)((double)weight * (1.0 / LINEAR_COEF));
            }
            long score = (long)((double)weight * coefficient);
            Lookup.LookupResult result = doHighlight ? new Lookup.LookupResult((CharSequence)text, this.highlight(text, matchedTokens, prefixToken), score, payload) : new Lookup.LookupResult((CharSequence)text, score, payload);
            BlendedInfixSuggester.boundedTreeAdd(results, result, actualNum);
        }
        return new ArrayList<Lookup.LookupResult>(results.descendingSet());
    }

    private static void boundedTreeAdd(TreeSet<Lookup.LookupResult> results, Lookup.LookupResult result, int num) {
        if (results.size() >= num) {
            if (results.first().value < result.value) {
                results.pollFirst();
            } else {
                return;
            }
        }
        results.add(result);
    }

    private double createCoefficient(IndexSearcher searcher, int doc, Set<String> matchedTokens, String prefixToken) throws IOException {
        BytesRef term;
        Terms tv = searcher.getIndexReader().getTermVector(doc, "text");
        TermsEnum it = tv.iterator();
        Integer position = Integer.MAX_VALUE;
        while ((term = it.next()) != null) {
            String docTerm = term.utf8ToString();
            if (!matchedTokens.contains(docTerm) && (prefixToken == null || !docTerm.startsWith(prefixToken))) continue;
            PostingsEnum docPosEnum = it.postings(null, 56);
            docPosEnum.nextDoc();
            int p = docPosEnum.nextPosition();
            if (p >= position) continue;
            position = p;
        }
        return this.calculateCoefficient(position);
    }

    protected double calculateCoefficient(int position) {
        double coefficient;
        switch (this.blenderType) {
            case POSITION_LINEAR: {
                coefficient = 1.0 - LINEAR_COEF * (double)position;
                break;
            }
            case POSITION_RECIPROCAL: {
                coefficient = 1.0 / (double)(position + 1);
                break;
            }
            case POSITION_EXPONENTIAL_RECIPROCAL: {
                coefficient = 1.0 / Math.pow((double)position + 1.0, this.exponent);
                break;
            }
            default: {
                coefficient = 1.0;
            }
        }
        return coefficient;
    }

    private static class LookUpComparator
    implements Comparator<Lookup.LookupResult> {
        private LookUpComparator() {
        }

        @Override
        public int compare(Lookup.LookupResult o1, Lookup.LookupResult o2) {
            if (o1.value > o2.value) {
                return 1;
            }
            if (o1.value < o2.value) {
                return -1;
            }
            int keyCompare = Lookup.CHARSEQUENCE_COMPARATOR.compare(o1.key, o2.key);
            if (keyCompare != 0) {
                return keyCompare;
            }
            if (o1.payload != null) {
                return o1.payload.compareTo(o2.payload);
            }
            return 0;
        }
    }

    public static enum BlenderType {
        CUSTOM,
        POSITION_LINEAR,
        POSITION_RECIPROCAL,
        POSITION_EXPONENTIAL_RECIPROCAL;

    }
}

