/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.spatial.composite;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreScorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreWeight;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.QueryVisitor;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TwoPhaseIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Weight;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial.util.ShapeValuesPredicate;

public class CompositeVerifyQuery
extends Query {
    private final Query indexQuery;
    private final ShapeValuesPredicate predicateValueSource;

    public CompositeVerifyQuery(Query indexQuery, ShapeValuesPredicate predicateValueSource) {
        this.indexQuery = indexQuery;
        this.predicateValueSource = predicateValueSource;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.indexQuery.rewrite(reader);
        if (rewritten != this.indexQuery) {
            return new CompositeVerifyQuery(rewritten, this.predicateValueSource);
        }
        return super.rewrite(reader);
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((CompositeVerifyQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(CompositeVerifyQuery other) {
        return this.indexQuery.equals(other.indexQuery) && this.predicateValueSource.equals(other.predicateValueSource);
    }

    @Override
    public int hashCode() {
        int result = this.classHash();
        result = 31 * result + this.indexQuery.hashCode();
        result = 31 * result + this.predicateValueSource.hashCode();
        return result;
    }

    @Override
    public String toString(String field) {
        return this.getClass().getSimpleName() + "(" + this.indexQuery.toString(field) + ", " + this.predicateValueSource + ")";
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final Weight indexQueryWeight = this.indexQuery.createWeight(searcher, ScoreMode.COMPLETE_NO_SCORES, boost);
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                Scorer indexQueryScorer = indexQueryWeight.scorer(context);
                if (indexQueryScorer == null) {
                    return null;
                }
                TwoPhaseIterator predFuncValues = CompositeVerifyQuery.this.predicateValueSource.iterator(context, indexQueryScorer.iterator());
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, predFuncValues);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return CompositeVerifyQuery.this.predicateValueSource.isCacheable(ctx);
            }
        };
    }
}

