/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Bounds;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoBasePolygon;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoPolygon;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoShape;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Membership;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Plane;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.SerializableObject;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.SidedPlane;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Vector;

class GeoConvexPolygon
extends GeoBasePolygon {
    protected final List<GeoPoint> points;
    protected final BitSet isInternalEdges;
    protected final List<GeoPolygon> holes;
    protected SidedPlane[] edges = null;
    protected GeoPoint[][] notableEdgePoints = null;
    protected GeoPoint[] edgePoints = null;
    protected boolean isDone = false;
    protected Map<SidedPlane, Membership> eitherBounds = null;
    protected Map<SidedPlane, SidedPlane> prevBrotherMap = null;
    protected Map<SidedPlane, SidedPlane> nextBrotherMap = null;

    public GeoConvexPolygon(PlanetModel planetModel, List<GeoPoint> pointList) {
        this(planetModel, pointList, null);
    }

    public GeoConvexPolygon(PlanetModel planetModel, List<GeoPoint> pointList, List<GeoPolygon> holes) {
        super(planetModel);
        this.points = pointList;
        this.holes = holes != null && holes.size() == 0 ? null : holes;
        this.isInternalEdges = new BitSet();
        this.done(false);
    }

    public GeoConvexPolygon(PlanetModel planetModel, List<GeoPoint> pointList, BitSet internalEdgeFlags, boolean returnEdgeInternal) {
        this(planetModel, pointList, null, internalEdgeFlags, returnEdgeInternal);
    }

    public GeoConvexPolygon(PlanetModel planetModel, List<GeoPoint> pointList, List<GeoPolygon> holes, BitSet internalEdgeFlags, boolean returnEdgeInternal) {
        super(planetModel);
        this.points = pointList;
        this.holes = holes != null && holes.size() == 0 ? null : holes;
        this.isInternalEdges = internalEdgeFlags;
        this.done(returnEdgeInternal);
    }

    public GeoConvexPolygon(PlanetModel planetModel, double startLatitude, double startLongitude) {
        this(planetModel, startLatitude, startLongitude, null);
    }

    public GeoConvexPolygon(PlanetModel planetModel, double startLatitude, double startLongitude, List<GeoPolygon> holes) {
        super(planetModel);
        this.points = new ArrayList<GeoPoint>();
        this.holes = holes != null && holes.size() == 0 ? null : holes;
        this.isInternalEdges = new BitSet();
        this.points.add(new GeoPoint(planetModel, startLatitude, startLongitude));
    }

    public void addPoint(double latitude, double longitude, boolean isInternalEdge) {
        if (this.isDone) {
            throw new IllegalStateException("Can't call addPoint() if done() already called");
        }
        if (isInternalEdge) {
            this.isInternalEdges.set(this.points.size() - 1);
        }
        this.points.add(new GeoPoint(this.planetModel, latitude, longitude));
    }

    public void done(boolean isInternalReturnEdge) {
        if (this.isDone) {
            throw new IllegalStateException("Can't call done() more than once");
        }
        if (this.points.size() < 3) {
            throw new IllegalArgumentException("Polygon needs at least three points.");
        }
        if (isInternalReturnEdge) {
            this.isInternalEdges.set(this.points.size() - 1);
        }
        this.isDone = true;
        this.edges = new SidedPlane[this.points.size()];
        this.notableEdgePoints = new GeoPoint[this.points.size()][];
        for (int i = 0; i < this.points.size(); ++i) {
            SidedPlane sp;
            GeoPoint start = this.points.get(i);
            GeoPoint end = this.points.get(this.legalIndex(i + 1));
            Plane planeToFind = new Plane((Vector)start, end);
            int endPointIndex = -1;
            for (int j = 0; j < this.points.size(); ++j) {
                int index = this.legalIndex(j + i + 2);
                if (planeToFind.evaluateIsZero(this.points.get(index))) continue;
                endPointIndex = index;
                break;
            }
            if (endPointIndex == -1) {
                throw new IllegalArgumentException("Polygon points are all coplanar: " + this.points);
            }
            GeoPoint check = this.points.get(endPointIndex);
            this.edges[i] = sp = new SidedPlane((Vector)check, (Vector)start, end);
            this.notableEdgePoints[i] = new GeoPoint[]{start, end};
        }
        this.eitherBounds = new HashMap<SidedPlane, Membership>(this.edges.length);
        this.prevBrotherMap = new HashMap<SidedPlane, SidedPlane>(this.edges.length);
        this.nextBrotherMap = new HashMap<SidedPlane, SidedPlane>(this.edges.length);
        for (int edgeIndex = 0; edgeIndex < this.edges.length; ++edgeIndex) {
            SidedPlane edge = this.edges[edgeIndex];
            int bound1Index = this.legalIndex(edgeIndex + 1);
            while (this.edges[bound1Index].isNumericallyIdentical(edge)) {
                if (bound1Index == edgeIndex) {
                    throw new IllegalArgumentException("Constructed planes are all coplanar: " + this.points);
                }
                bound1Index = this.legalIndex(bound1Index + 1);
            }
            int bound2Index = this.legalIndex(edgeIndex - 1);
            while (this.edges[bound2Index].isNumericallyIdentical(edge)) {
                if (bound2Index == edgeIndex) {
                    throw new IllegalArgumentException("Constructed planes are all coplanar: " + this.points);
                }
                bound2Index = this.legalIndex(bound2Index - 1);
            }
            int startingIndex = bound2Index;
            while ((startingIndex = this.legalIndex(startingIndex + 1)) != bound1Index) {
                GeoPoint interiorPoint = this.points.get(startingIndex);
                if (this.edges[bound1Index].isWithin(interiorPoint) && this.edges[bound2Index].isWithin(interiorPoint)) continue;
                throw new IllegalArgumentException("Convex polygon has a side that is more than 180 degrees");
            }
            this.eitherBounds.put(edge, new EitherBound(this.edges[bound1Index], this.edges[bound2Index]));
            this.nextBrotherMap.put(edge, this.edges[bound1Index]);
            this.prevBrotherMap.put(edge, this.edges[bound2Index]);
        }
        int edgePointCount = 1;
        if (this.holes != null) {
            for (GeoPolygon hole : this.holes) {
                edgePointCount += hole.getEdgePoints().length;
            }
        }
        this.edgePoints = new GeoPoint[edgePointCount];
        edgePointCount = 0;
        this.edgePoints[edgePointCount++] = this.points.get(0);
        if (this.holes != null) {
            for (GeoPolygon hole : this.holes) {
                GeoPoint[] holeEdgePoints;
                for (GeoPoint p : holeEdgePoints = hole.getEdgePoints()) {
                    this.edgePoints[edgePointCount++] = p;
                }
            }
        }
        if (this.isWithinHoles(this.points.get(0))) {
            throw new IllegalArgumentException("Polygon edge intersects a polygon hole; not allowed");
        }
    }

    protected boolean isWithinHoles(GeoPoint point) {
        if (this.holes != null) {
            for (GeoPolygon hole : this.holes) {
                if (hole.isWithin(point)) continue;
                return true;
            }
        }
        return false;
    }

    protected int legalIndex(int index) {
        while (index >= this.points.size()) {
            index -= this.points.size();
        }
        while (index < 0) {
            index += this.points.size();
        }
        return index;
    }

    public GeoConvexPolygon(PlanetModel planetModel, InputStream inputStream) throws IOException {
        super(planetModel);
        this.points = Arrays.asList(SerializableObject.readPointArray(planetModel, inputStream));
        List<GeoPolygon> holes = Arrays.asList(SerializableObject.readPolygonArray(planetModel, inputStream));
        this.holes = holes != null && holes.size() == 0 ? null : holes;
        this.isInternalEdges = SerializableObject.readBitSet(inputStream);
        this.done(this.isInternalEdges.get(this.points.size() - 1));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writePointArray(outputStream, this.points);
        SerializableObject.writePolygonArray(outputStream, this.holes);
        SerializableObject.writeBitSet(outputStream, this.isInternalEdges);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        if (!this.localIsWithin(x, y, z)) {
            return false;
        }
        if (this.holes != null) {
            for (GeoPolygon polygon : this.holes) {
                if (polygon.isWithin(x, y, z)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean localIsWithin(Vector v) {
        return this.localIsWithin(v.x, v.y, v.z);
    }

    protected boolean localIsWithin(double x, double y, double z) {
        for (SidedPlane edge : this.edges) {
            if (edge.isWithin(x, y, z)) continue;
            return false;
        }
        return true;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        for (int edgeIndex = 0; edgeIndex < this.edges.length; ++edgeIndex) {
            SidedPlane edge = this.edges[edgeIndex];
            GeoPoint[] points = this.notableEdgePoints[edgeIndex];
            if (this.isInternalEdges.get(edgeIndex) || !edge.intersects(this.planetModel, p, notablePoints, points, bounds, this.eitherBounds.get(edge))) continue;
            return true;
        }
        if (this.holes != null) {
            for (GeoPolygon hole : this.holes) {
                if (!hole.intersects(p, notablePoints, bounds)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean intersects(GeoShape shape) {
        for (int edgeIndex = 0; edgeIndex < this.edges.length; ++edgeIndex) {
            SidedPlane edge = this.edges[edgeIndex];
            GeoPoint[] points = this.notableEdgePoints[edgeIndex];
            if (this.isInternalEdges.get(edgeIndex) || !shape.intersects(edge, points, this.eitherBounds.get(edge))) continue;
            return true;
        }
        if (this.holes != null) {
            for (GeoPolygon hole : this.holes) {
                if (!hole.intersects(shape)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void getBounds(Bounds bounds) {
        if (this.localIsWithin(this.planetModel.NORTH_POLE)) {
            bounds.noTopLatitudeBound().noLongitudeBound().addPoint(this.planetModel.NORTH_POLE);
        }
        if (this.localIsWithin(this.planetModel.SOUTH_POLE)) {
            bounds.noBottomLatitudeBound().noLongitudeBound().addPoint(this.planetModel.SOUTH_POLE);
        }
        if (this.localIsWithin(this.planetModel.MIN_X_POLE)) {
            bounds.addPoint(this.planetModel.MIN_X_POLE);
        }
        if (this.localIsWithin(this.planetModel.MAX_X_POLE)) {
            bounds.addPoint(this.planetModel.MAX_X_POLE);
        }
        if (this.localIsWithin(this.planetModel.MIN_Y_POLE)) {
            bounds.addPoint(this.planetModel.MIN_Y_POLE);
        }
        if (this.localIsWithin(this.planetModel.MAX_Y_POLE)) {
            bounds.addPoint(this.planetModel.MAX_Y_POLE);
        }
        for (GeoPoint point : this.points) {
            bounds.addPoint(point);
        }
        for (SidedPlane edge : this.edges) {
            bounds.addPlane(this.planetModel, edge, this.eitherBounds.get(edge));
            SidedPlane nextEdge = this.nextBrotherMap.get(edge);
            bounds.addIntersection(this.planetModel, edge, nextEdge, this.prevBrotherMap.get(edge), this.nextBrotherMap.get(nextEdge));
        }
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double minimumDistance = Double.POSITIVE_INFINITY;
        for (GeoPoint edgePoint : this.points) {
            double newDist = distanceStyle.computeDistance(edgePoint, x, y, z);
            if (!(newDist < minimumDistance)) continue;
            minimumDistance = newDist;
        }
        for (SidedPlane edgePlane : this.edges) {
            Membership[] membershipArray = new Membership[]{this.eitherBounds.get(edgePlane)};
            double newDist = distanceStyle.computeDistance(this.planetModel, (Plane)edgePlane, x, y, z, membershipArray);
            if (!(newDist < minimumDistance)) continue;
            minimumDistance = newDist;
        }
        if (this.holes != null) {
            for (GeoPolygon hole : this.holes) {
                double holeDistance = hole.computeOutsideDistance(distanceStyle, x, y, z);
                if (holeDistance == 0.0 || !(holeDistance < minimumDistance)) continue;
                minimumDistance = holeDistance;
            }
        }
        return minimumDistance;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoConvexPolygon)) {
            return false;
        }
        GeoConvexPolygon other = (GeoConvexPolygon)o;
        if (!super.equals(other)) {
            return false;
        }
        if (!other.isInternalEdges.equals(this.isInternalEdges)) {
            return false;
        }
        if (other.holes != null || this.holes != null) {
            if (other.holes == null || this.holes == null) {
                return false;
            }
            if (!other.holes.equals(this.holes)) {
                return false;
            }
        }
        return other.points.equals(this.points);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.points.hashCode();
        if (this.holes != null) {
            result = 31 * result + this.holes.hashCode();
        }
        return result;
    }

    public String toString() {
        return "GeoConvexPolygon: {planetmodel=" + this.planetModel + ", points=" + this.points + ", internalEdges=" + this.isInternalEdges + (String)(this.holes == null ? "" : ", holes=" + this.holes) + "}";
    }

    protected static class EitherBound
    implements Membership {
        protected final SidedPlane sideBound1;
        protected final SidedPlane sideBound2;

        public EitherBound(SidedPlane sideBound1, SidedPlane sideBound2) {
            this.sideBound1 = sideBound1;
            this.sideBound2 = sideBound2;
        }

        @Override
        public boolean isWithin(Vector v) {
            return this.sideBound1.isWithin(v) && this.sideBound2.isWithin(v);
        }

        @Override
        public boolean isWithin(double x, double y, double z) {
            return this.sideBound1.isWithin(x, y, z) && this.sideBound2.isWithin(x, y, z);
        }

        public String toString() {
            return "(" + this.sideBound1 + "," + this.sideBound2 + ")";
        }
    }
}

