/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Bounds;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoBBox;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoBBoxFactory;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoBaseBBox;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoShape;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Membership;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Plane;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.SerializableObject;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.SidedPlane;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Vector;

public class GeoDegenerateVerticalLine
extends GeoBaseBBox {
    protected final double topLat;
    protected final double bottomLat;
    protected final double longitude;
    protected final GeoPoint UHC;
    protected final GeoPoint LHC;
    protected final SidedPlane topPlane;
    protected final SidedPlane bottomPlane;
    protected final SidedPlane boundingPlane;
    protected final Plane plane;
    protected final GeoPoint[] planePoints;
    protected final GeoPoint centerPoint;
    protected final GeoPoint[] edgePoints;

    public GeoDegenerateVerticalLine(PlanetModel planetModel, double topLat, double bottomLat, double longitude) {
        super(planetModel);
        if (topLat > 1.5707963267948966 || topLat < -1.5707963267948966) {
            throw new IllegalArgumentException("Top latitude out of range");
        }
        if (bottomLat > 1.5707963267948966 || bottomLat < -1.5707963267948966) {
            throw new IllegalArgumentException("Bottom latitude out of range");
        }
        if (topLat < bottomLat) {
            throw new IllegalArgumentException("Top latitude less than bottom latitude");
        }
        if (longitude < -Math.PI || longitude > Math.PI) {
            throw new IllegalArgumentException("Longitude out of range");
        }
        this.topLat = topLat;
        this.bottomLat = bottomLat;
        this.longitude = longitude;
        double sinTopLat = Math.sin(topLat);
        double cosTopLat = Math.cos(topLat);
        double sinBottomLat = Math.sin(bottomLat);
        double cosBottomLat = Math.cos(bottomLat);
        double sinLongitude = Math.sin(longitude);
        double cosLongitude = Math.cos(longitude);
        this.UHC = new GeoPoint(planetModel, sinTopLat, sinLongitude, cosTopLat, cosLongitude, topLat, longitude);
        this.LHC = new GeoPoint(planetModel, sinBottomLat, sinLongitude, cosBottomLat, cosLongitude, bottomLat, longitude);
        this.plane = new Plane(cosLongitude, sinLongitude);
        double middleLat = (topLat + bottomLat) * 0.5;
        double sinMiddleLat = Math.sin(middleLat);
        double cosMiddleLat = Math.cos(middleLat);
        this.centerPoint = new GeoPoint(planetModel, sinMiddleLat, sinLongitude, cosMiddleLat, cosLongitude);
        this.topPlane = new SidedPlane((Vector)this.centerPoint, planetModel, sinTopLat);
        this.bottomPlane = new SidedPlane((Vector)this.centerPoint, planetModel, sinBottomLat);
        this.boundingPlane = new SidedPlane((Vector)this.centerPoint, -sinLongitude, cosLongitude);
        this.planePoints = new GeoPoint[]{this.UHC, this.LHC};
        this.edgePoints = new GeoPoint[]{this.centerPoint};
    }

    public GeoDegenerateVerticalLine(PlanetModel planetModel, InputStream inputStream) throws IOException {
        this(planetModel, SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeDouble(outputStream, this.topLat);
        SerializableObject.writeDouble(outputStream, this.bottomLat);
        SerializableObject.writeDouble(outputStream, this.longitude);
    }

    @Override
    public GeoBBox expand(double angle) {
        double newTopLat = this.topLat + angle;
        double newBottomLat = this.bottomLat - angle;
        double newLeftLon = this.longitude - angle;
        double newRightLon = this.longitude + angle;
        double currentLonSpan = 2.0 * angle;
        if (currentLonSpan + 2.0 * angle >= Math.PI * 2) {
            newLeftLon = -Math.PI;
            newRightLon = Math.PI;
        }
        return GeoBBoxFactory.makeGeoBBox(this.planetModel, newTopLat, newBottomLat, newLeftLon, newRightLon);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.plane.evaluateIsZero(x, y, z) && this.boundingPlane.isWithin(x, y, z) && this.topPlane.isWithin(x, y, z) && this.bottomPlane.isWithin(x, y, z);
    }

    @Override
    public double getRadius() {
        double topAngle = this.centerPoint.arcDistance(this.UHC);
        double bottomAngle = this.centerPoint.arcDistance(this.LHC);
        return Math.max(topAngle, bottomAngle);
    }

    @Override
    public GeoPoint getCenter() {
        return this.centerPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.planetModel, this.plane, notablePoints, this.planePoints, bounds, this.boundingPlane, this.topPlane, this.bottomPlane);
    }

    @Override
    public boolean intersects(GeoShape geoShape) {
        return geoShape.intersects(this.plane, this.planePoints, this.boundingPlane, this.topPlane, this.bottomPlane);
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        bounds.addVerticalPlane(this.planetModel, this.longitude, this.plane, this.boundingPlane, this.topPlane, this.bottomPlane).addPoint(this.UHC).addPoint(this.LHC);
    }

    @Override
    public int getRelationship(GeoShape path) {
        if (this.intersects(path)) {
            return 2;
        }
        if (path.isWithin(this.centerPoint)) {
            return 0;
        }
        return 3;
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double distance = distanceStyle.computeDistance(this.planetModel, this.plane, x, y, z, this.topPlane, this.bottomPlane, this.boundingPlane);
        double UHCDistance = distanceStyle.computeDistance(this.UHC, x, y, z);
        double LHCDistance = distanceStyle.computeDistance(this.LHC, x, y, z);
        return Math.min(distance, Math.min(UHCDistance, LHCDistance));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoDegenerateVerticalLine)) {
            return false;
        }
        GeoDegenerateVerticalLine other = (GeoDegenerateVerticalLine)o;
        return super.equals(other) && other.UHC.equals(this.UHC) && other.LHC.equals(this.LHC);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.UHC.hashCode();
        result = 31 * result + this.LHC.hashCode();
        return result;
    }

    public String toString() {
        return "GeoDegenerateVerticalLine: {longitude=" + this.longitude + "(" + this.longitude * 180.0 / Math.PI + "), toplat=" + this.topLat + "(" + this.topLat * 180.0 / Math.PI + "), bottomlat=" + this.bottomLat + "(" + this.bottomLat * 180.0 / Math.PI + ")}";
    }
}

