/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom;

import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Bounds;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Membership;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Plane;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.PlanetModel;

public class XYZBounds
implements Bounds {
    private static final double FUDGE_FACTOR = 1.0E-9;
    private Double minX = null;
    private Double maxX = null;
    private Double minY = null;
    private Double maxY = null;
    private Double minZ = null;
    private Double maxZ = null;

    public Double getMinimumX() {
        return this.minX;
    }

    public Double getMaximumX() {
        return this.maxX;
    }

    public Double getMinimumY() {
        return this.minY;
    }

    public Double getMaximumY() {
        return this.maxY;
    }

    public Double getMinimumZ() {
        return this.minZ;
    }

    public Double getMaximumZ() {
        return this.maxZ;
    }

    public boolean isSmallestMinX(PlanetModel planetModel) {
        if (this.minX == null) {
            return false;
        }
        return this.minX - planetModel.getMinimumXValue() < 1.0E-12;
    }

    public boolean isLargestMaxX(PlanetModel planetModel) {
        if (this.maxX == null) {
            return false;
        }
        return planetModel.getMaximumXValue() - this.maxX < 1.0E-12;
    }

    public boolean isSmallestMinY(PlanetModel planetModel) {
        if (this.minY == null) {
            return false;
        }
        return this.minY - planetModel.getMinimumYValue() < 1.0E-12;
    }

    public boolean isLargestMaxY(PlanetModel planetModel) {
        if (this.maxY == null) {
            return false;
        }
        return planetModel.getMaximumYValue() - this.maxY < 1.0E-12;
    }

    public boolean isSmallestMinZ(PlanetModel planetModel) {
        if (this.minZ == null) {
            return false;
        }
        return this.minZ - planetModel.getMinimumZValue() < 1.0E-12;
    }

    public boolean isLargestMaxZ(PlanetModel planetModel) {
        if (this.maxZ == null) {
            return false;
        }
        return planetModel.getMaximumZValue() - this.maxZ < 1.0E-12;
    }

    @Override
    public Bounds addPlane(PlanetModel planetModel, Plane plane, Membership ... bounds) {
        plane.recordBounds(planetModel, this, bounds);
        return this;
    }

    @Override
    public Bounds addHorizontalPlane(PlanetModel planetModel, double latitude, Plane horizontalPlane, Membership ... bounds) {
        return this.addPlane(planetModel, horizontalPlane, bounds);
    }

    @Override
    public Bounds addVerticalPlane(PlanetModel planetModel, double longitude, Plane verticalPlane, Membership ... bounds) {
        return this.addPlane(planetModel, verticalPlane, bounds);
    }

    @Override
    public Bounds addXValue(GeoPoint point) {
        return this.addXValue(point.x);
    }

    public Bounds addXValue(double x) {
        double small = x - 1.0E-9;
        if (this.minX == null || this.minX > small) {
            this.minX = small;
        }
        double large = x + 1.0E-9;
        if (this.maxX == null || this.maxX < large) {
            this.maxX = large;
        }
        return this;
    }

    @Override
    public Bounds addYValue(GeoPoint point) {
        return this.addYValue(point.y);
    }

    public Bounds addYValue(double y) {
        double small = y - 1.0E-9;
        if (this.minY == null || this.minY > small) {
            this.minY = small;
        }
        double large = y + 1.0E-9;
        if (this.maxY == null || this.maxY < large) {
            this.maxY = large;
        }
        return this;
    }

    @Override
    public Bounds addZValue(GeoPoint point) {
        return this.addZValue(point.z);
    }

    public Bounds addZValue(double z) {
        double small = z - 1.0E-9;
        if (this.minZ == null || this.minZ > small) {
            this.minZ = small;
        }
        double large = z + 1.0E-9;
        if (this.maxZ == null || this.maxZ < large) {
            this.maxZ = large;
        }
        return this;
    }

    @Override
    public Bounds addIntersection(PlanetModel planetModel, Plane plane1, Plane plane2, Membership ... bounds) {
        plane1.recordBounds(planetModel, this, plane2, bounds);
        return this;
    }

    @Override
    public Bounds addPoint(GeoPoint point) {
        return this.addXValue(point).addYValue(point).addZValue(point);
    }

    @Override
    public Bounds isWide() {
        return this;
    }

    @Override
    public Bounds noLongitudeBound() {
        return this;
    }

    @Override
    public Bounds noTopLatitudeBound() {
        return this;
    }

    @Override
    public Bounds noBottomLatitudeBound() {
        return this;
    }

    @Override
    public Bounds noBound(PlanetModel planetModel) {
        this.minX = planetModel.getMinimumXValue();
        this.maxX = planetModel.getMaximumXValue();
        this.minY = planetModel.getMinimumYValue();
        this.maxY = planetModel.getMaximumYValue();
        this.minZ = planetModel.getMinimumZValue();
        this.maxZ = planetModel.getMaximumZValue();
        return this;
    }

    public String toString() {
        return "XYZBounds: [xmin=" + this.minX + " xmax=" + this.maxX + " ymin=" + this.minY + " ymax=" + this.maxY + " zmin=" + this.minZ + " zmax=" + this.maxZ + "]";
    }
}

