/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.BaseXYZSolid;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoShape;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Plane;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.SerializableObject;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.SidedPlane;

class dXYdZSolid
extends BaseXYZSolid {
    protected final double X;
    protected final double minY;
    protected final double maxY;
    protected final double Z;
    protected final GeoPoint[] surfacePoints;

    public dXYdZSolid(PlanetModel planetModel, double X, double minY, double maxY, double Z) {
        super(planetModel);
        if (maxY - minY < 1.0E-12) {
            throw new IllegalArgumentException("Y values in wrong order or identical");
        }
        this.X = X;
        this.minY = minY;
        this.maxY = maxY;
        this.Z = Z;
        Plane xPlane = new Plane(xUnitVector, -X);
        Plane zPlane = new Plane(zUnitVector, -Z);
        SidedPlane minYPlane = new SidedPlane(0.0, maxY, 0.0, yUnitVector, -minY);
        SidedPlane maxYPlane = new SidedPlane(0.0, minY, 0.0, yUnitVector, -maxY);
        this.surfacePoints = xPlane.findIntersections(planetModel, zPlane, minYPlane, maxYPlane);
    }

    public dXYdZSolid(PlanetModel planetModel, InputStream inputStream) throws IOException {
        this(planetModel, SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeDouble(outputStream, this.X);
        SerializableObject.writeDouble(outputStream, this.minY);
        SerializableObject.writeDouble(outputStream, this.maxY);
        SerializableObject.writeDouble(outputStream, this.Z);
    }

    @Override
    protected GeoPoint[] getEdgePoints() {
        return this.surfacePoints;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        for (GeoPoint p : this.surfacePoints) {
            if (!p.isIdentical(x, y, z)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getRelationship(GeoShape path) {
        int insideRectangle = this.isShapeInsideArea(path);
        if (insideRectangle == 1) {
            return 2;
        }
        int insideShape = this.isAreaInsideShape(path);
        if (insideShape == 1) {
            return 2;
        }
        if (insideRectangle == 0 && insideShape == 0) {
            return 2;
        }
        if (insideRectangle == 0) {
            return 1;
        }
        if (insideShape == 0) {
            return 0;
        }
        return 3;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof dXYdZSolid)) {
            return false;
        }
        dXYdZSolid other = (dXYdZSolid)o;
        if (!super.equals(other) || this.surfacePoints.length != other.surfacePoints.length) {
            return false;
        }
        for (int i = 0; i < this.surfacePoints.length; ++i) {
            if (this.surfacePoints[i].equals(other.surfacePoints[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        for (GeoPoint p : this.surfacePoints) {
            result = 31 * result + p.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (GeoPoint p : this.surfacePoints) {
            sb.append(" ").append(p).append(" ");
        }
        return "dXYdZSolid: {planetmodel=" + this.planetModel + ", " + sb.toString() + "}";
    }
}

