/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;

public final class BitUtil {
    public static final VarHandle VH_LE_SHORT = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.LITTLE_ENDIAN);
    public static final VarHandle VH_LE_INT = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    public static final VarHandle VH_LE_LONG = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    public static final VarHandle VH_LE_FLOAT = MethodHandles.byteArrayViewVarHandle(float[].class, ByteOrder.LITTLE_ENDIAN);
    public static final VarHandle VH_LE_DOUBLE = MethodHandles.byteArrayViewVarHandle(double[].class, ByteOrder.LITTLE_ENDIAN);
    @Deprecated
    public static final VarHandle VH_BE_SHORT = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.BIG_ENDIAN);
    @Deprecated
    public static final VarHandle VH_BE_INT = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.BIG_ENDIAN);
    @Deprecated
    public static final VarHandle VH_BE_LONG = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.BIG_ENDIAN);
    @Deprecated
    public static final VarHandle VH_BE_FLOAT = MethodHandles.byteArrayViewVarHandle(float[].class, ByteOrder.BIG_ENDIAN);
    @Deprecated
    public static final VarHandle VH_BE_DOUBLE = MethodHandles.byteArrayViewVarHandle(double[].class, ByteOrder.BIG_ENDIAN);
    private static final long MAGIC0 = 0x5555555555555555L;
    private static final long MAGIC1 = 0x3333333333333333L;
    private static final long MAGIC2 = 0xF0F0F0F0F0F0F0FL;
    private static final long MAGIC3 = 0xFF00FF00FF00FFL;
    private static final long MAGIC4 = 0xFFFF0000FFFFL;
    private static final long MAGIC5 = 0xFFFFFFFFL;
    private static final long MAGIC6 = -6148914691236517206L;
    private static final long SHIFT0 = 1L;
    private static final long SHIFT1 = 2L;
    private static final long SHIFT2 = 4L;
    private static final long SHIFT3 = 8L;
    private static final long SHIFT4 = 16L;

    private BitUtil() {
    }

    public static int nextHighestPowerOfTwo(int v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return ++v;
    }

    public static long nextHighestPowerOfTwo(long v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        v |= v >> 32;
        return ++v;
    }

    public static long interleave(int even, int odd) {
        long v1 = 0xFFFFFFFFL & (long)even;
        long v2 = 0xFFFFFFFFL & (long)odd;
        v1 = (v1 | v1 << 16) & 0xFFFF0000FFFFL;
        v1 = (v1 | v1 << 8) & 0xFF00FF00FF00FFL;
        v1 = (v1 | v1 << 4) & 0xF0F0F0F0F0F0F0FL;
        v1 = (v1 | v1 << 2) & 0x3333333333333333L;
        v1 = (v1 | v1 << 1) & 0x5555555555555555L;
        v2 = (v2 | v2 << 16) & 0xFFFF0000FFFFL;
        v2 = (v2 | v2 << 8) & 0xFF00FF00FF00FFL;
        v2 = (v2 | v2 << 4) & 0xF0F0F0F0F0F0F0FL;
        v2 = (v2 | v2 << 2) & 0x3333333333333333L;
        v2 = (v2 | v2 << 1) & 0x5555555555555555L;
        return v2 << 1 | v1;
    }

    public static long deinterleave(long b) {
        b &= 0x5555555555555555L;
        b = (b ^ b >>> 1) & 0x3333333333333333L;
        b = (b ^ b >>> 2) & 0xF0F0F0F0F0F0F0FL;
        b = (b ^ b >>> 4) & 0xFF00FF00FF00FFL;
        b = (b ^ b >>> 8) & 0xFFFF0000FFFFL;
        b = (b ^ b >>> 16) & 0xFFFFFFFFL;
        return b;
    }

    public static long flipFlop(long b) {
        return (b & 0xAAAAAAAAAAAAAAAAL) >>> 1 | (b & 0x5555555555555555L) << 1;
    }

    public static int zigZagEncode(int i) {
        return i >> 31 ^ i << 1;
    }

    public static long zigZagEncode(long l) {
        return l >> 63 ^ l << 1;
    }

    public static int zigZagDecode(int i) {
        return i >>> 1 ^ -(i & 1);
    }

    public static long zigZagDecode(long l) {
        return l >>> 1 ^ -(l & 1L);
    }
}

