/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util;

import org.graylog.shaded.opensearch2.org.apache.lucene.util.InPlaceMergeSorter;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.MSBRadixSorter;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Sorter;

public abstract class StableMSBRadixSorter
extends MSBRadixSorter {
    private final int[] fixedStartOffsets = new int[257];

    public StableMSBRadixSorter(int maxLength) {
        super(maxLength);
    }

    protected abstract void save(int var1, int var2);

    protected abstract void restore(int var1, int var2);

    @Override
    protected Sorter getFallbackSorter(final int k) {
        return new InPlaceMergeSorter(){

            @Override
            protected void swap(int i, int j) {
                StableMSBRadixSorter.this.swap(i, j);
            }

            @Override
            protected int compare(int i, int j) {
                for (int o = k; o < StableMSBRadixSorter.this.maxLength; ++o) {
                    int b2;
                    int b1 = StableMSBRadixSorter.this.byteAt(i, o);
                    if (b1 != (b2 = StableMSBRadixSorter.this.byteAt(j, o))) {
                        return b1 - b2;
                    }
                    if (b1 == -1) break;
                }
                return 0;
            }
        };
    }

    @Override
    protected void reorder(int from, int to, int[] startOffsets, int[] endOffsets, int k) {
        System.arraycopy(startOffsets, 0, this.fixedStartOffsets, 0, startOffsets.length);
        for (int i = 0; i < 257; ++i) {
            int limit = endOffsets[i];
            for (int h1 = this.fixedStartOffsets[i]; h1 < limit; ++h1) {
                int h2;
                int b;
                int n = b = this.getBucket(from + h1, k);
                startOffsets[n] = startOffsets[n] + 1;
                this.save(from + h1, from + h2);
            }
        }
        this.restore(from, to);
    }
}

