/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util;

public final class VectorUtil {
    private VectorUtil() {
    }

    public static float dotProduct(float[] a, float[] b) {
        int i;
        if (a.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length + "!=" + b.length);
        }
        float res = 0.0f;
        for (i = 0; i < a.length % 8; ++i) {
            res += b[i] * a[i];
        }
        if (a.length < 8) {
            return res;
        }
        while (i + 31 < a.length) {
            res += b[i + 0] * a[i + 0] + b[i + 1] * a[i + 1] + b[i + 2] * a[i + 2] + b[i + 3] * a[i + 3] + b[i + 4] * a[i + 4] + b[i + 5] * a[i + 5] + b[i + 6] * a[i + 6] + b[i + 7] * a[i + 7];
            res += b[i + 8] * a[i + 8] + b[i + 9] * a[i + 9] + b[i + 10] * a[i + 10] + b[i + 11] * a[i + 11] + b[i + 12] * a[i + 12] + b[i + 13] * a[i + 13] + b[i + 14] * a[i + 14] + b[i + 15] * a[i + 15];
            res += b[i + 16] * a[i + 16] + b[i + 17] * a[i + 17] + b[i + 18] * a[i + 18] + b[i + 19] * a[i + 19] + b[i + 20] * a[i + 20] + b[i + 21] * a[i + 21] + b[i + 22] * a[i + 22] + b[i + 23] * a[i + 23];
            res += b[i + 24] * a[i + 24] + b[i + 25] * a[i + 25] + b[i + 26] * a[i + 26] + b[i + 27] * a[i + 27] + b[i + 28] * a[i + 28] + b[i + 29] * a[i + 29] + b[i + 30] * a[i + 30] + b[i + 31] * a[i + 31];
            i += 32;
        }
        while (i + 7 < a.length) {
            res += b[i + 0] * a[i + 0] + b[i + 1] * a[i + 1] + b[i + 2] * a[i + 2] + b[i + 3] * a[i + 3] + b[i + 4] * a[i + 4] + b[i + 5] * a[i + 5] + b[i + 6] * a[i + 6] + b[i + 7] * a[i + 7];
            i += 8;
        }
        return res;
    }

    public static float cosine(float[] v1, float[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + v1.length + "!=" + v2.length);
        }
        float sum = 0.0f;
        float norm1 = 0.0f;
        float norm2 = 0.0f;
        int dim = v1.length;
        for (int i = 0; i < dim; ++i) {
            float elem1 = v1[i];
            float elem2 = v2[i];
            sum += elem1 * elem2;
            norm1 += elem1 * elem1;
            norm2 += elem2 * elem2;
        }
        return (float)((double)sum / Math.sqrt(norm1 * norm2));
    }

    public static float squareDistance(float[] v1, float[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + v1.length + "!=" + v2.length);
        }
        float squareSum = 0.0f;
        int dim = v1.length;
        int i = 0;
        while (i + 8 <= dim) {
            squareSum += VectorUtil.squareDistanceUnrolled8(v1, v2, i);
            i += 8;
        }
        while (i < dim) {
            float diff = v1[i] - v2[i];
            squareSum += diff * diff;
            ++i;
        }
        return squareSum;
    }

    private static float squareDistanceUnrolled8(float[] v1, float[] v2, int index) {
        float diff0 = v1[index + 0] - v2[index + 0];
        float diff1 = v1[index + 1] - v2[index + 1];
        float diff2 = v1[index + 2] - v2[index + 2];
        float diff3 = v1[index + 3] - v2[index + 3];
        float diff4 = v1[index + 4] - v2[index + 4];
        float diff5 = v1[index + 5] - v2[index + 5];
        float diff6 = v1[index + 6] - v2[index + 6];
        float diff7 = v1[index + 7] - v2[index + 7];
        return diff0 * diff0 + diff1 * diff1 + diff2 * diff2 + diff3 * diff3 + diff4 * diff4 + diff5 * diff5 + diff6 * diff6 + diff7 * diff7;
    }

    public static float[] l2normalize(float[] v) {
        VectorUtil.l2normalize(v, true);
        return v;
    }

    public static float[] l2normalize(float[] v, boolean throwOnZero) {
        double squareSum = 0.0;
        int dim = v.length;
        for (float x : v) {
            squareSum += (double)(x * x);
        }
        if (squareSum == 0.0) {
            if (throwOnZero) {
                throw new IllegalArgumentException("Cannot normalize a zero-length vector");
            }
            return v;
        }
        double length = Math.sqrt(squareSum);
        int i = 0;
        while (i < dim) {
            int n = i++;
            v[n] = (float)((double)v[n] / length);
        }
        return v;
    }

    public static void add(float[] u, float[] v) {
        for (int i = 0; i < u.length; ++i) {
            int n = i;
            u[n] = u[n] + v[i];
        }
    }
}

