/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public abstract class HnswGraph {
    public static HnswGraph EMPTY = new HnswGraph(){

        @Override
        public int nextNeighbor() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void seek(int level, int target) {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int numLevels() {
            return 0;
        }

        @Override
        public int entryNode() {
            return 0;
        }

        @Override
        public NodesIterator getNodesOnLevel(int level) {
            return NodesIterator.EMPTY;
        }
    };

    protected HnswGraph() {
    }

    public abstract void seek(int var1, int var2) throws IOException;

    public abstract int size();

    public abstract int nextNeighbor() throws IOException;

    public abstract int numLevels() throws IOException;

    public abstract int entryNode() throws IOException;

    public abstract NodesIterator getNodesOnLevel(int var1) throws IOException;

    public static final class NodesIterator
    implements PrimitiveIterator.OfInt {
        static NodesIterator EMPTY = new NodesIterator(0);
        private final int[] nodes;
        private final int size;
        int cur = 0;

        public NodesIterator(int[] nodes, int size) {
            assert (nodes != null);
            assert (size <= nodes.length);
            this.nodes = nodes;
            this.size = size;
        }

        public NodesIterator(int size) {
            this.nodes = null;
            this.size = size;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.nodes == null) {
                return this.cur++;
            }
            return this.nodes[this.cur++];
        }

        @Override
        public boolean hasNext() {
            return this.cur < this.size;
        }

        public int size() {
            return this.size;
        }
    }
}

